<?php $__env->startSection('admin-content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0"><?php echo e(__('app.cashboxes.heading')); ?></h4>
            <p class="text-muted small mb-0"><?php echo e(__('app.cashboxes.description')); ?></p>
        </div>
        <a href="<?php echo e(route('admin.cashboxes.create')); ?>" class="btn btn-primary btn-rounded">
            <i class="bi bi-plus me-2"></i><?php echo e(__('app.cashboxes.new_cashbox')); ?>

        </a>
    </div>

    <div class="row g-3">
        <?php $__currentLoopData = $cashboxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cashbox): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-6">
                <div class="border rounded-4 p-3 h-100">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h5 class="fw-bold mb-1"><?php echo e($cashbox->name); ?></h5>
                            <p class="text-muted small mb-2"><?php echo e($cashbox->entries_count); ?> <?php echo e(__('app.cashboxes.movements')); ?></p>
                        </div>
                        <div class="text-end">
                            <div class="fw-semibold"><?php echo e(__('app.cashboxes.balance')); ?></div>
                            <div class="fs-4 fw-bold"><?php echo e(number_format($cashbox->current_balance, 2)); ?></div>
                        </div>
                    </div>
                    <a href="<?php echo e(route('admin.cashboxes.show', $cashbox)); ?>" class="btn btn-outline-primary btn-sm btn-rounded"><?php echo e(__('app.cashboxes.open')); ?></a>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', ['title' => __('app.cashboxes.title')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Lavandera\resources\views/admin/cashboxes/index.blade.php ENDPATH**/ ?>