<?php $__env->startSection('title', __('app.front.receipt.title') . ' · ' . $serviceOrder->order_number); ?>

<?php $__env->startPush('styles'); ?>
<style>
    @media print {
        /* إخفاء القائمة والهيدر */
        nav,
        .btn,
        .no-print,
        footer,
        .footer-masbana {
            display: none !important;
        }

        /* إزالة الهوامش والمسافات */
        body {
            margin: 0;
            padding: 0;
            background: white;
        }

        .container {
            max-width: 100%;
            padding: 0;
        }

        /* تنسيق الإيصال للطباعة */
        .masbana-card {
            box-shadow: none;
            border: none;
            padding: 20px !important;
            margin: 0;
        }

        /* تحسين الطباعة */
        @page {
            size: A4;
            margin: 1cm;
        }

        /* إخفاء أي عناصر إضافية */
        main::before,
        main::after {
            display: none;
        }

        <?php if(request('copy') == 2): ?>
            /* ضغط المحتوى ليناسب صفحة واحدة عند طباعة نسختين */
            @page {
                margin: 0.5cm;
            }
            .masbana-card {
                padding: 1rem !important;
                border: 1px solid #eee !important; /* إضافة حدود خفيفة للفصل */
            }
            body {
                font-size: 12px;
            }
            h1.h4 {
                font-size: 1.1rem !important;
            }
            .mb-3 {
                margin-bottom: 0.5rem !important;
            }
            .mt-4 {
                margin-top: 1rem !important;
            }
            .table td, .table th {
                padding: 0.25rem 0.5rem !important;
            }
            /* تقليل المسافة الفاصلة */
            .my-4 {
                margin-top: 0.5rem !important;
                margin-bottom: 0.5rem !important;
            }
        <?php endif; ?>
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        $copyCount = request('copy') == 2 ? 2 : 1;
    ?>

    <?php for($i = 0; $i < $copyCount; $i++): ?>
        <div class="masbana-card p-4 <?php echo e($i > 0 ? 'mt-4' : ''); ?>" style="page-break-inside: avoid;">
            <div class="d-flex justify-content-between align-items-start mb-3">
                <div>
                    <h1 class="h4 fw-bold mb-1"><?php echo e($settings['company_name']); ?></h1>
                    <div class="text-muted small">
                        <?php echo e($settings['company_address']); ?> · <?php echo e($settings['company_phone']); ?>

                    </div>
                    <div class="text-muted small"><?php echo e(__('app.front.receipt.copy')); ?> <?php echo e($copyCount == 2 ? ($i + 1) : request('copy', 1)); ?> <?php echo e(__('app.front.receipt.of')); ?> <?php echo e($settings['receipt_copies']); ?></div>
                </div>
                <div class="text-end">
                    <div class="fw-semibold"><?php echo e(__('app.front.receipt.order')); ?> #<?php echo e($serviceOrder->order_number); ?></div>
                    <div class="text-muted small"><?php echo e(__('app.front.receipt.barcode')); ?>: <?php echo e($serviceOrder->barcode); ?></div>
                    <div class="text-muted small"><?php echo e(__('app.front.receipt.date')); ?>: <?php echo e($serviceOrder->created_at->format('d M Y H:i')); ?></div>
                </div>
            </div>

            <div class="d-flex flex-wrap gap-3 mb-3 align-items-start">
                <div class="flex-grow-1">
                    <span class="text-muted small"><?php echo e(__('app.front.receipt.customer')); ?>:</span>
                    <span class="fw-semibold ms-1"><?php echo e($serviceOrder->customer_name ?? __('app.front.receipt.walk_in')); ?></span>
                    <span class="text-muted ms-2"><?php echo e(__('app.front.receipt.gender')); ?>: <?php echo e(__('app.front.' . $serviceOrder->gender)); ?></span>
                </div>
                <div>
                    <span class="text-muted small"><?php echo e(__('app.front.receipt.service')); ?>:</span>
                    <span class="fw-semibold ms-1"><?php echo e(__('app.front.' . $serviceOrder->service_type)); ?></span>
                    <span class="text-muted ms-2"><?php echo e(__('app.front.receipt.status')); ?>: <?php echo e(__('app.orders.show.statuses.' . $serviceOrder->status)); ?></span>
                </div>
            </div>

            <table class="table table-borderless align-middle mb-3">
                <thead class="table-light">
                    <tr>
                        <th><?php echo e(__('app.front.receipt.item')); ?></th>
                        <th class="text-center"><?php echo e(__('app.front.receipt.service')); ?></th>
                        <th class="text-center"><?php echo e(__('app.front.receipt.qty')); ?></th>
                        <th class="text-end"><?php echo e(__('app.front.receipt.unit')); ?></th>
                        <th class="text-end"><?php echo e(__('app.front.receipt.total')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $serviceOrder->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <?php echo e($item->clothingItem->name); ?>

                                <?php if($item->color): ?>
                                    <?php
                                        $colorMap = [
                                            'white' => '#ffffff',
                                            'black' => '#000000',
                                            'red' => '#dc3545',
                                            'blue' => '#0d6efd',
                                            'green' => '#198754',
                                            'yellow' => '#ffc107',
                                            'orange' => '#fd7e14',
                                            'purple' => '#6f42c1',
                                            'pink' => '#e91e63',
                                            'brown' => '#8b4513',
                                            'gray' => '#6c757d',
                                            'beige' => '#f5f5dc',
                                            'navy' => '#001f3f',
                                            'other' => '#cccccc'
                                        ];
                                        $hexColor = $colorMap[$item->color] ?? '#cccccc';
                                        $textColor = (in_array($item->color, ['white', 'beige', 'yellow'])) ? '#000000' : '#ffffff';
                                    ?>
                                    <span class="badge ms-2" style="background-color: <?php echo e($hexColor); ?>; color: <?php echo e($textColor); ?>; border: 1px solid <?php echo e(($item->color == 'white' || $item->color == 'beige') ? '#ddd' : 'rgba(0,0,0,0.1)'); ?>;"><?php echo e(__('app.front.colors.' . $item->color)); ?></span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <?php if($item->service_type): ?>
                                    <span class="badge bg-primary-subtle text-primary"><?php echo e(__('app.front.' . $item->service_type)); ?></span>
                                <?php else: ?>
                                    <span class="badge bg-primary-subtle text-primary"><?php echo e(__('app.front.' . $serviceOrder->service_type)); ?></span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center"><?php echo e($item->quantity); ?></td>
                            <td class="text-end"><?php echo e($settings['currency']); ?> <?php echo e(number_format($item->unit_price, 2)); ?></td>
                            <td class="text-end"><?php echo e($settings['currency']); ?> <?php echo e(number_format($item->line_total, 2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="4" class="text-end text-muted"><?php echo e(__('app.front.receipt.subtotal')); ?></td>
                        <td class="text-end"><?php echo e($settings['currency']); ?> <?php echo e(number_format($serviceOrder->subtotal, 2)); ?></td>
                    </tr>
                    <tr>
                        <td colspan="4" class="text-end text-muted"><?php echo e(__('app.front.receipt.discount')); ?></td>
                        <td class="text-end">- <?php echo e($settings['currency']); ?> <?php echo e(number_format($serviceOrder->discount_amount, 2)); ?></td>
                    </tr>
                    <tr>
                        <td colspan="4" class="text-end fw-bold"><?php echo e(__('app.front.receipt.total')); ?></td>
                        <td class="text-end fw-bold"><?php echo e($settings['currency']); ?> <?php echo e(number_format($serviceOrder->total, 2)); ?></td>
                    </tr>
                </tfoot>
            </table>

            <div class="receipt-bottom-section d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mt-3">
                <div>
                    <small class="text-muted"><?php echo e(__('app.front.receipt.payment_status')); ?>: <?php echo e(__('app.orders.show.statuses.' . $serviceOrder->payment_status)); ?></small><br>
                    <small class="text-muted"><?php echo e(__('app.front.receipt.thank_you')); ?></small>
                </div>
                <div class="text-center">
                    <svg class="receipt-barcode w-100" style="max-width:320px;"></svg>
                    <div class="small text-muted mt-2"><?php echo e(__('app.front.receipt.scan_hint')); ?></div>
                </div>
                <?php if($i == 0): ?>
                    <button class="btn btn-primary btn-rounded mt-3 mt-md-0 no-print" onclick="window.print()">
                        <i class="bi bi-printer me-2"></i><?php echo e(__('app.front.receipt.print')); ?>

                    </button>
                <?php endif; ?>
            </div>
        </div>
        <?php if($i < $copyCount - 1): ?>
            <div class="d-print-block d-none border-bottom border-secondary border-dashed my-4" style="border-style: dashed !important;"></div>
        <?php endif; ?>
    <?php endfor; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            JsBarcode(".receipt-barcode", "<?php echo e($serviceOrder->barcode); ?>", {
                format: "CODE128",
                lineColor: "#0d1b2a",
                width: 2,
                height: 80,
                displayValue: true,
            });
        });
    </script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Lavandera\resources\views/front/receipt.blade.php ENDPATH**/ ?>