<?php $__env->startSection('admin-content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0"><?php echo e(__('app.transactions.cashflow_monitor')); ?></h4>
            <p class="text-muted small mb-0"><?php echo e(__('app.transactions.description')); ?></p>
        </div>
        <a href="<?php echo e(route('admin.transactions.create')); ?>" class="btn btn-primary btn-rounded">
            <i class="bi bi-plus-lg me-2"></i><?php echo e(__('app.transactions.new_transaction')); ?>

        </a>
    </div>

    <form class="row g-2 align-items-end mb-4">
        <div class="col-md-3">
            <label class="form-label"><?php echo e(__('app.transactions.type')); ?></label>
            <select name="type" class="form-select rounded-4">
                <option value=""><?php echo e(__('app.transactions.all')); ?></option>
                <option value="income" <?php if(request('type') === 'income'): echo 'selected'; endif; ?>><?php echo e(__('app.transactions.income')); ?></option>
                <option value="expense" <?php if(request('type') === 'expense'): echo 'selected'; endif; ?>><?php echo e(__('app.transactions.expense')); ?></option>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?php echo e(__('app.transactions.from')); ?></label>
            <input type="date" name="from" class="form-control rounded-4" value="<?php echo e(request('from')); ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label"><?php echo e(__('app.transactions.to')); ?></label>
            <input type="date" name="to" class="form-control rounded-4" value="<?php echo e(request('to')); ?>">
        </div>
        <div class="col-md-3">
            <button class="btn btn-outline-primary btn-rounded w-100" type="submit"><?php echo e(__('app.transactions.apply')); ?></button>
        </div>
    </form>

    <div class="table-responsive">
        <table class="table align-middle">
            <thead>
                <tr>
                    <th><?php echo e(__('app.transactions.date')); ?></th>
                    <th><?php echo e(__('app.transactions.type')); ?></th>
                    <th><?php echo e(__('app.transactions.category')); ?></th>
                    <th><?php echo e(__('app.transactions.amount')); ?></th>
                    <th><?php echo e(__('app.transactions.cashbox')); ?></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e(\Illuminate\Support\Carbon::parse($transaction->occurred_on)->format('d M Y')); ?></td>
                        <td class="text-capitalize"><?php echo e($transaction->type === 'income' ? __('app.transactions.income') : __('app.transactions.expense')); ?></td>
                        <td><?php echo e($transaction->category); ?></td>
                        <td class="<?php echo e($transaction->type === 'income' ? 'text-success' : 'text-danger'); ?>">
                            <?php echo e($transaction->type === 'income' ? '+' : '-'); ?><?php echo e(number_format($transaction->amount, 2)); ?>

                        </td>
                        <td><?php echo e($transaction->cashbox->name ?? '—'); ?></td>
                        <td class="text-end">
                            <a href="<?php echo e(route('admin.transactions.show', $transaction)); ?>" class="btn btn-sm btn-outline-primary"><?php echo e(__('app.transactions.view')); ?></a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center text-muted py-5"><?php echo e(__('app.transactions.none')); ?></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php echo e($transactions->links()); ?>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', ['title' => __('app.transactions.title')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Lavandera\resources\views/admin/transactions/index.blade.php ENDPATH**/ ?>