<?php $__env->startSection('admin-content'); ?>
    <div class="d-flex justify-content-between mb-4">
        <div>
            <h4 class="fw-bold mb-1"><?php echo e(__('app.orders.show.title', ['number' => $serviceOrder->order_number])); ?></h4>
            <p class="text-muted mb-0"><?php echo e(__('app.orders.show.barcode_label')); ?>: <?php echo e($serviceOrder->barcode); ?></p>
        </div>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('service-orders.receipt', ['serviceOrder' => $serviceOrder->id])); ?>" target="_blank" class="btn btn-outline-primary btn-rounded">
                <i class="bi bi-printer me-2"></i><?php echo e(__('app.orders.show.print_receipt')); ?>

            </a>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_orders')): ?>
                <button type="button" class="btn btn-outline-danger btn-rounded" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($serviceOrder->id); ?>">
                    <i class="bi bi-trash me-2"></i><?php echo e(__('app.orders.show.delete')); ?>

                </button>
            <?php endif; ?>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-md-7">
            <h6 class="heading-label mb-2"><?php echo e(__('app.orders.show.items')); ?></h6>
            <div class="table-responsive mb-4">
                <table class="table table-sm align-middle">
                    <thead>
                        <tr>
                            <th><?php echo e(__('app.orders.show.item')); ?></th>
                            <th class="text-center"><?php echo e(__('app.orders.show.qty')); ?></th>
                            <th class="text-end"><?php echo e(__('app.orders.show.line_total')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $serviceOrder->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e($item->clothingItem->name); ?>

                                    <?php if($item->color): ?>
                                        <span class="badge bg-secondary-subtle text-secondary ms-2"><?php echo e(__('app.front.colors.' . $item->color)); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center"><?php echo e($item->quantity); ?></td>
                                <td class="text-end"><?php echo e(number_format($item->line_total, 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="2" class="text-end"><?php echo e(__('app.orders.show.subtotal')); ?></td>
                            <td class="text-end"><?php echo e(number_format($serviceOrder->subtotal, 2)); ?></td>
                        </tr>
                        <tr>
                            <td colspan="2" class="text-end"><?php echo e(__('app.orders.show.discount')); ?></td>
                            <td class="text-end">- <?php echo e(number_format($serviceOrder->discount_amount, 2)); ?></td>
                        </tr>
                        <tr>
                            <td colspan="2" class="text-end fw-bold"><?php echo e(__('app.orders.show.total')); ?></td>
                            <td class="text-end fw-bold"><?php echo e(number_format($serviceOrder->total, 2)); ?></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
        <div class="col-md-5">
            <h6 class="heading-label mb-2"><?php echo e(__('app.orders.show.update_status')); ?></h6>
            <form action="<?php echo e(route('admin.orders.update', $serviceOrder)); ?>" method="POST" class="border rounded-4 p-3">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="mb-3">
                    <label class="form-label"><?php echo e(__('app.orders.show.status')); ?></label>
                    <select name="status" class="form-select rounded-4">
                        <?php $__currentLoopData = ['processing','ready','collected']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($status); ?>" <?php if($serviceOrder->status === $status): echo 'selected'; endif; ?>><?php echo e(__('app.orders.show.statuses.' . $status)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" role="switch" id="markPaid" name="mark_paid" value="1" <?php echo e($serviceOrder->payment_status === 'paid' ? 'checked disabled' : ''); ?>>
                    <label class="form-check-label" for="markPaid"><?php echo e(__('app.orders.show.mark_paid')); ?></label>
                </div>
                <button class="btn btn-primary btn-rounded" type="submit"><?php echo e(__('app.orders.show.save_changes')); ?></button>
            </form>

            <div class="mt-4">
                <h6 class="heading-label mb-2"><?php echo e(__('app.orders.show.barcode')); ?></h6>
                <svg id="adminOrderBarcode" style="width:100%;height:120px;"></svg>
                <small class="text-muted"><?php echo e(__('app.orders.show.barcode_hint')); ?></small>
            </div>
        </div>
    </div>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_orders')): ?>
        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal<?php echo e($serviceOrder->id); ?>" tabindex="-1" aria-labelledby="deleteModalLabel<?php echo e($serviceOrder->id); ?>" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header border-0 pb-0">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center px-4 pb-4">
                        <div class="mb-3">
                            <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 64px; height: 64px;">
                                <i class="bi bi-exclamation-triangle-fill text-danger fs-2"></i>
                            </div>
                        </div>
                        <h5 class="modal-title fw-bold mb-2" id="deleteModalLabel<?php echo e($serviceOrder->id); ?>"><?php echo e(__('app.orders.show.delete_confirm')); ?></h5>
                        <p class="text-muted mb-0">
                            <?php echo e(__('app.orders.table.order')); ?>: <strong><?php echo e($serviceOrder->order_number); ?></strong><br>
                            <?php echo e(__('app.orders.show.barcode_label')); ?>: <strong><?php echo e($serviceOrder->barcode); ?></strong>
                        </p>
                    </div>
                    <div class="modal-footer border-0 justify-content-center gap-2 pb-4">
                        <button type="button" class="btn btn-outline-secondary btn-rounded" data-bs-dismiss="modal">
                            <?php echo e(__('app.orders.show.cancel')); ?>

                        </button>
                        <form action="<?php echo e(route('admin.orders.destroy', $serviceOrder)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-rounded">
                                <i class="bi bi-trash me-2"></i><?php echo e(__('app.orders.show.delete')); ?>

                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            JsBarcode("#adminOrderBarcode", "<?php echo e($serviceOrder->barcode); ?>", {
                format: "CODE128",
                width: 2,
                height: 80,
                displayValue: true,
            });
        });
    </script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('layouts.admin', ['title' => __('app.orders.show.title', ['number' => $serviceOrder->order_number])], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Lavandera\resources\views/admin/orders/show.blade.php ENDPATH**/ ?>