<?php $__env->startSection('admin-content'); ?>

    <div class="row g-4">
        <div class="col-md-4">
            <div class="border rounded-4 p-3 bg-light">
                <p class="heading-label mb-1"><?php echo e(__('app.dashboard_cards.processing')); ?></p>
                <div class="display-6 fw-bold"><?php echo e($stats['processing_orders']); ?></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded-4 p-3 bg-light">
                <p class="heading-label mb-1"><?php echo e(__('app.dashboard_cards.ready')); ?></p>
                <div class="display-6 fw-bold"><?php echo e($stats['ready_orders']); ?></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded-4 p-3 bg-light">
                <p class="heading-label mb-1"><?php echo e(__('app.dashboard_cards.collected')); ?></p>
                <div class="display-6 fw-bold"><?php echo e($stats['collected_today']); ?></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded-4 p-3">
                <p class="heading-label mb-1"><?php echo e(__('app.dashboard_cards.revenue')); ?></p>
                <div class="display-6 fw-bold text-success"><?php echo e(number_format($stats['revenue_today'], 2)); ?></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded-4 p-3">
                <p class="heading-label mb-1"><?php echo e(__('app.dashboard_cards.expenses')); ?></p>
                <div class="display-6 fw-bold text-danger"><?php echo e(number_format($stats['expenses_today'], 2)); ?></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded-4 p-3">
                <p class="heading-label mb-1"><?php echo e(__('app.dashboard_cards.cashbox')); ?></p>
                <div class="display-6 fw-bold"><?php echo e(number_format($stats['cashbox_balance'], 2)); ?></div>
            </div>
        </div>
    </div>

    <div class="row g-4 mt-1">
        <div class="col-lg-6">
            <h5 class="fw-bold mb-3"><?php echo e(__('app.dashboard_cards.recent_orders')); ?></h5>
            <div class="list-group">
                <?php $__empty_1 = true; $__currentLoopData = $recentOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="list-group-item list-group-item-action d-flex justify-content-between">
                        <div>
                            <div class="fw-semibold"><?php echo e($order->order_number); ?></div>
                            <small class="text-muted"><?php echo e(ucfirst($order->service_type)); ?> · <?php echo e(trans_choice('app.orders.items_count', $order->items->count(), ['count' => $order->items->count()])); ?></small>
                        </div>
                        <div class="text-end">
                            <div class="fw-bold"><?php echo e(number_format($order->total, 2)); ?></div>
                            <small class="text-muted"><?php echo e(ucfirst($order->status)); ?></small>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-muted"><?php echo e(__('app.dashboard_cards.orders_empty')); ?></div>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-lg-6">
            <h5 class="fw-bold mb-3"><?php echo e(__('app.dashboard_cards.recent_transactions')); ?></h5>
            <div class="list-group">
                <?php $__empty_1 = true; $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="list-group-item d-flex justify-content-between">
                        <div>
                            <div class="fw-semibold text-capitalize"><?php echo e($transaction->type); ?> · <?php echo e($transaction->category); ?></div>
                            <small class="text-muted"><?php echo e(\Illuminate\Support\Carbon::parse($transaction->occurred_on)->format('d M Y')); ?></small>
                        </div>
                        <div class="fw-bold <?php echo e($transaction->type === 'income' ? 'text-success' : 'text-danger'); ?>">
                            <?php echo e($transaction->type === 'income' ? '+' : '-'); ?><?php echo e(number_format($transaction->amount, 2)); ?>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-muted"><?php echo e(__('app.dashboard_cards.transactions_empty')); ?></div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', ['title' => __('app.admin.dashboard')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\pressing\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>