<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-7">
            <div class="masbana-card p-5">
                <!-- Header -->
                <div class="text-center mb-4">
                    <div class="bg-primary-subtle rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="bi bi-key-fill text-primary fs-1"></i>
                    </div>
                    <h3 class="fw-bold mb-2"><?php echo e(__('app.license.activate_title')); ?></h3>
                    <p class="text-muted"><?php echo e(__('app.license.activate_subtitle')); ?></p>
                </div>

                <!-- Success Message -->
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show rounded-4" role="alert">
                        <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <!-- Error Message -->
                <?php if($errors->has('license')): ?>
                    <div class="alert alert-danger alert-dismissible fade show rounded-4" role="alert">
                        <i class="bi bi-exclamation-triangle me-2"></i><?php echo e($errors->first('license')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <!-- License Info (if activated) -->
                <?php if($licenseInfo && $licenseInfo['is_valid']): ?>
                    <div class="alert alert-success rounded-4 mb-4">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-check-circle me-2 fs-4"></i>
                            <div>
                                <strong class="d-block"><?php echo e(__('app.license.activated')); ?></strong>
                                <p class="mb-0 small"><?php echo e(__('app.license.license_info')); ?></p>
                                <?php if($licenseInfo['expires_at']): ?>
                                    <p class="mb-0 small mt-1"><?php echo e(__('app.license.expires_at')); ?>: <strong><?php echo e($licenseInfo['expires_at']); ?></strong></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Activation Form -->
                <form action="<?php echo e(route('license.activate')); ?>" method="POST" id="activationForm">
                    <?php echo csrf_field(); ?>
                    
                    <!-- License Key -->
                    <div class="mb-3">
                        <label for="license_key" class="form-label fw-semibold">
                            <?php echo e(__('app.license.license_key')); ?> 
                            <span class="text-danger">*</span>
                        </label>
                        <input type="text" 
                               class="form-control form-control-lg rounded-4 <?php $__errorArgs = ['license_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="license_key" 
                               name="license_key" 
                               placeholder="XXXX-XXXX-XXXX-XXXX"
                               value="<?php echo e(old('license_key')); ?>"
                               required
                               autofocus>
                        <small class="form-text text-muted"><?php echo e(__('app.license.license_key_hint')); ?></small>
                        <?php $__errorArgs = ['license_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Serial Number -->
                    <div class="mb-3">
                        <label for="serial_number" class="form-label fw-semibold">
                            <?php echo e(__('app.license.serial_number')); ?> 
                            <span class="text-danger">*</span>
                        </label>
                        <input type="text" 
                               class="form-control form-control-lg rounded-4 <?php $__errorArgs = ['serial_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="serial_number" 
                               name="serial_number" 
                               placeholder="SN-XXXXXXXXXXXX"
                               value="<?php echo e(old('serial_number')); ?>"
                               required>
                        <small class="form-text text-muted"><?php echo e(__('app.license.serial_number_hint')); ?></small>
                        <?php $__errorArgs = ['serial_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Customer Information -->
                    <div class="row mb-4">
                        <div class="col-md-6 mb-3 mb-md-0">
                            <label for="name" class="form-label fw-semibold"><?php echo e(__('app.license.customer_name')); ?></label>
                            <input type="text" 
                                   class="form-control rounded-4 <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="name" 
                                   name="name" 
                                   value="<?php echo e(old('name')); ?>"
                                   placeholder="<?php echo e(__('app.license.customer_name')); ?>">
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <label for="email" class="form-label fw-semibold"><?php echo e(__('app.license.email')); ?></label>
                            <input type="email" 
                                   class="form-control rounded-4 <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="email" 
                                   name="email" 
                                   value="<?php echo e(old('email')); ?>"
                                   placeholder="<?php echo e(__('app.license.email')); ?>">
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="d-grid mb-3">
                        <button type="submit" class="btn btn-primary btn-lg btn-rounded">
                            <i class="bi bi-check-circle me-2"></i><?php echo e(__('app.license.activate')); ?>

                        </button>
                    </div>
                </form>

                <!-- Back to Login -->
                <div class="text-center">
                    <a href="<?php echo e(route('login')); ?>" class="text-decoration-none">
                        <i class="bi bi-arrow-left me-2"></i><?php echo e(__('app.license.back_to_login')); ?>

                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Auto-format license key input
    document.getElementById('license_key')?.addEventListener('input', function(e) {
        let value = e.target.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
        if (value.length > 16) value = value.substring(0, 16);
        let formatted = value.match(/.{1,4}/g)?.join('-') || value;
        if (formatted.length > 19) formatted = formatted.substring(0, 19);
        e.target.value = formatted;
    });
    
    // Auto-format serial number input
    document.getElementById('serial_number')?.addEventListener('input', function(e) {
        let value = e.target.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
        if (!value.startsWith('SN')) {
            value = 'SN' + value;
        }
        if (value.length > 3) {
            value = 'SN-' + value.substring(2);
        }
        if (value.length > 15) value = value.substring(0, 15);
        e.target.value = value;
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => __('app.license.activate_title')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Lavandera\resources\views/license/activate.blade.php ENDPATH**/ ?>