<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(config('app.dir', 'ltr')); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title', __('app.brand')); ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --masbana-sky: #5cb9ff;
            --masbana-sky-dark: #3e8dd3;
            --masbana-sky-light: #e6f4ff;
            --masbana-text: #0d1b2a;
            --masbana-muted: #5f6b7c;
            --masbana-bg: #ddeef8;
        }

        body {
            font-family: 'Inter', 'Cairo', system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: var(--masbana-bg);
            color: var(--masbana-text);
            min-height: 100vh;
        }

        .masbana-card {
            border: none;
            border-radius: 1.25rem;
            box-shadow: 0 20px 45px rgba(40, 132, 199, 0.12);
            background: #fff;
        }

        .btn-rounded {
            border-radius: 999px;
            padding: 0.65rem 1.5rem;
            font-weight: 600;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }

        .btn-rounded:hover {
            transform: translateY(-1px);
            box-shadow: 0 10px 25px rgba(92, 185, 255, 0.35);
        }

        .heading-label {
            font-size: 0.9rem;
            font-weight: 600;
            letter-spacing: 0.06em;
            text-transform: uppercase;
            color: var(--masbana-muted);
        }

        .nav-masbana {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(8px);
            border-bottom: 1px solid rgba(92, 185, 255, 0.2);
            position: relative;
            z-index: 1030;
            overflow: visible !important;
        }

        /* Dropdown menu appears in front of all elements */
        .nav-masbana .dropdown {
            position: relative;
            z-index: 10000 !important;
        }

        .nav-masbana .dropdown-menu,
        .nav-masbana .dropdown-menu.show,
        #userMenu + .dropdown-menu,
        #userMenu + .dropdown-menu.show,
        .dropdown-menu.dropdown-menu-end {
            z-index: 10000 !important;
            position: absolute !important;
        }

        /* Ensure dropdown container doesn't clip */
        .nav-masbana .container {
            overflow: visible !important;
        }

        /* Footer Styles */
        .footer-masbana {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(8px);
            border-top: 1px solid rgba(92, 185, 255, 0.2);
            margin-top: auto;
            font-size: 0.9rem;
        }

        .footer-masbana a {
            transition: color 0.2s ease;
        }

        .footer-masbana a:hover {
            color: var(--masbana-sky-dark) !important;
        }

        /* Trial Warning Notification */
        .trial-warning-notification {
            background: linear-gradient(135deg, #fff3cd 0%, #ffe69c 100%);
            border: 2px solid #ffc107;
            border-radius: 1rem;
            padding: 1.25rem;
            box-shadow: 0 4px 15px rgba(255, 193, 7, 0.25);
            animation: slideDown 0.5s ease-out;
        }

        .trial-warning-icon {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
            box-shadow: 0 4px 10px rgba(255, 193, 7, 0.4);
        }

        .trial-warning-icon i {
            font-size: 1.5rem;
            color: #fff;
            animation: pulse 2s infinite;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes pulse {
            0%, 100% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.1);
            }
        }

        body {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        main {
            flex: 1;
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <nav class="nav-masbana py-3 mb-4">
        <div class="container d-flex justify-content-between align-items-center flex-wrap gap-3">
            <div class="d-flex align-items-center gap-3">
                <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center" style="width:48px;height:48px;background:var(--masbana-sky);">
                    <i class="bi bi-droplet text-white fs-4"></i>
                </div>
                <div class="<?php echo e(app()->getLocale() === 'ar' ? 'text-end' : ''); ?>">
                    <div class="fw-bold fs-4 text-uppercase" style="color:var(--masbana-sky-dark);"><?php echo e(__('app.brand')); ?></div>
                    <div class="text-muted small"><?php echo e(__('app.tagline')); ?></div>
                </div>
            </div>
            <div class="d-flex gap-2 align-items-center">
                <form action="<?php echo e(route('locale.switch')); ?>" method="POST" class="d-none d-md-flex align-items-center gap-2">
                    <?php echo csrf_field(); ?>
                    <label for="localeSwitch" class="text-muted small mb-0"><?php echo e(__('app.locale.label')); ?></label>
                    <select id="localeSwitch" name="locale" class="form-select form-select-lg rounded-pill" onchange="this.form.submit()">
                        <?php $__currentLoopData = config('app.available_locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($locale); ?>" <?php if(app()->getLocale() === $locale): echo 'selected'; endif; ?>>
                                <?php echo e(__('app.locale.' . $locale)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </form>
                <?php if(auth()->guard()->check()): ?>
                    <div class="dropdown d-none d-md-block">
                        <button class="btn btn-outline-primary btn-rounded dropdown-toggle" type="button" id="userMenu" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-person-circle me-2"></i><?php echo e(auth()->user()->name); ?>

                        </button>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userMenu">
                            <li><span class="dropdown-item-text small text-muted"><?php echo e(auth()->user()->email); ?></span></li>
                            <?php if(auth()->user()->role): ?>
                                <li><span class="dropdown-item-text small text-muted"><?php echo e(auth()->user()->role->display_name); ?></span></li>
                            <?php endif; ?>
                            <li><hr class="dropdown-divider"></li>
                            <?php if(auth()->user()->hasPermission('view_dashboard')): ?>
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.dashboard')); ?>"><i class="bi bi-speedometer me-2"></i><?php echo e(__('app.admin.dashboard')); ?></a></li>
                                <li><hr class="dropdown-divider"></li>
                            <?php endif; ?>
                            <li>
                                <form action="<?php echo e(route('logout')); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="dropdown-item text-danger">
                                        <i class="bi bi-box-arrow-right me-2"></i><?php echo e(__('app.auth.logout')); ?>

                                    </button>
                                </form>
                            </li>
                        </ul>
                    </div>
                    <a href="<?php echo e(route('service-orders.index')); ?>" class="btn btn-outline-primary btn-rounded d-none d-md-inline-flex">
                        <?php echo e(__('app.nav.front')); ?>

                    </a>
                <?php else: ?>
                    <a href="<?php echo e(route('service-orders.index')); ?>" class="btn btn-outline-primary btn-rounded d-none d-md-inline-flex">
                        <?php echo e(__('app.nav.front')); ?>

                    </a>
                    <a href="<?php echo e(route('login')); ?>" class="btn btn-primary btn-rounded">
                        <?php echo e(__('app.auth.login')); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>
        <div class="container d-md-none mt-3">
            <form action="<?php echo e(route('locale.switch')); ?>" method="POST" class="d-flex align-items-center gap-2">
                <?php echo csrf_field(); ?>
                <label for="localeSwitchMobile" class="text-muted small mb-0"><?php echo e(__('app.locale.label')); ?></label>
                <select id="localeSwitchMobile" name="locale" class="form-select form-select-sm rounded-pill" onchange="this.form.submit()">
                    <?php $__currentLoopData = config('app.available_locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($locale); ?>" <?php if(app()->getLocale() === $locale): echo 'selected'; endif; ?>>
                            <?php echo e(__('app.locale.' . $locale)); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </form>
        </div>
    </nav>

    <main class="container pb-5">
        <?php if(session('status')): ?>
            <div class="alert alert-success rounded-4 shadow-sm"><?php echo e(session('status')); ?></div>
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <div class="alert alert-danger rounded-4 shadow-sm">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <footer class="footer-masbana mt-4 py-3">
        <div class="container">
            <div class="row g-3 align-items-center">
                <div class="col-md-4">
                    <div class="d-flex align-items-center gap-2 mb-2">
                        <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center" style="width:36px;height:36px;background:var(--masbana-sky);">
                            <i class="bi bi-droplet text-white" style="font-size: 0.9rem;"></i>
                        </div>
                        <div>
                            <div class="fw-bold text-uppercase" style="color:var(--masbana-sky-dark);font-size:0.95rem;"><?php echo e(__('app.brand')); ?></div>
                            <div class="text-muted" style="font-size:0.8rem;"><?php echo e(__('app.tagline')); ?></div>
                        </div>
                    </div>
                    <p class="text-muted mb-0" style="font-size:0.8rem;"><?php echo e(__('app.footer.description')); ?></p>
                </div>
                <div class="col-md-2 col-6">
                    <h6 class="fw-semibold mb-2" style="font-size:0.9rem;"><?php echo e(__('app.footer.quick_links')); ?></h6>
                    <ul class="list-unstyled mb-0">
                        <li class="mb-1">
                            <a href="<?php echo e(route('service-orders.index')); ?>" class="text-muted text-decoration-none" style="font-size:0.8rem;">
                                <i class="bi bi-arrow-left-short me-1"></i><?php echo e(__('app.nav.front')); ?>

                            </a>
                        </li>
                        <?php if(auth()->guard()->check()): ?>
                            <?php if(auth()->user()->hasPermission('view_dashboard')): ?>
                                <li class="mb-1">
                                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-muted text-decoration-none" style="font-size:0.8rem;">
                                        <i class="bi bi-arrow-left-short me-1"></i><?php echo e(__('app.admin.dashboard')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php else: ?>
                            <li class="mb-1">
                                <a href="<?php echo e(route('login')); ?>" class="text-muted text-decoration-none" style="font-size:0.8rem;">
                                    <i class="bi bi-arrow-left-short me-1"></i><?php echo e(__('app.auth.login')); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="col-md-3 col-6">
                    <h6 class="fw-semibold mb-2" style="font-size:0.9rem;"><?php echo e(__('app.footer.contact')); ?></h6>
                    <ul class="list-unstyled mb-0">
                        <li class="mb-1 text-muted" style="font-size:0.8rem;">
                            <i class="bi bi-envelope me-1"></i><?php echo e(__('app.footer.email')); ?>

                        </li>
                        <li class="mb-1 text-muted" style="font-size:0.8rem;">
                            <i class="bi bi-telephone me-1"></i><?php echo e(__('app.footer.phone')); ?>

                        </li>
                        <li class="mb-1 text-muted" style="font-size:0.8rem;">
                            <i class="bi bi-geo-alt me-1"></i><?php echo e(__('app.footer.address')); ?>

                        </li>
                    </ul>
                </div>
                <div class="col-md-3">
                    <h6 class="fw-semibold mb-2" style="font-size:0.9rem;"><?php echo e(__('app.footer.info')); ?></h6>
                    <ul class="list-unstyled mb-0">
                        <li class="mb-1 text-muted" style="font-size:0.8rem;">
                            <i class="bi bi-info-circle me-1"></i><?php echo e(__('app.footer.version')); ?>: <strong>1.0.0</strong>
                        </li>
                        <li class="mb-1 text-muted" style="font-size:0.8rem;">
                            <i class="bi bi-calendar me-1"></i><?php echo e(__('app.footer.year')); ?>: <strong><?php echo e(date('Y')); ?></strong>
                        </li>
                        <li class="mb-1 text-muted" style="font-size:0.8rem;">
                            <i class="bi bi-shield-check me-1"></i><?php echo e(__('app.footer.license')); ?>

                        </li>
                    </ul>
                </div>
            </div>
            <hr class="my-2" style="border-color: rgba(92, 185, 255, 0.2);">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="text-muted mb-0" style="font-size:0.8rem;">
                        &copy; <?php echo e(date('Y')); ?> <?php echo e(__('app.brand')); ?>. <?php echo e(__('app.footer.all_rights_reserved')); ?>

                    </p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="text-muted mb-0" style="font-size:0.8rem;">
                        <strong style="color:var(--masbana-sky-dark);"><?php echo e(__('app.footer.developed_by')); ?></strong>
                    </p>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>

<?php /**PATH /home/imranei/www/lavandera/demos/demo1/resources/views/layouts/app.blade.php ENDPATH**/ ?>