

<?php $__env->startSection('admin-content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0"><?php echo e(__('app.permissions.title')); ?></h4>
            <p class="text-muted small mb-0"><?php echo e(__('app.permissions.description')); ?></p>
        </div>
        <a href="<?php echo e(route('admin.permissions.create')); ?>" class="btn btn-primary btn-rounded">
            <i class="bi bi-plus-lg me-2"></i><?php echo e(__('app.permissions.new_permission')); ?>

        </a>
    </div>

    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $groupPermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="mb-4">
            <h5 class="fw-semibold text-primary mb-3"><?php echo e($group ?: __('app.permissions.other')); ?></h5>
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead>
                        <tr>
                            <th><?php echo e(__('app.permissions.table.name')); ?></th>
                            <th><?php echo e(__('app.permissions.table.display_name')); ?></th>
                            <th><?php echo e(__('app.permissions.table.description')); ?></th>
                            <th><?php echo e(__('app.permissions.table.roles_count')); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $groupPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <code class="text-primary"><?php echo e($permission->name); ?></code>
                                </td>
                                <td class="fw-semibold"><?php echo e($permission->display_name); ?></td>
                                <td class="text-muted small"><?php echo e($permission->description ?: '-'); ?></td>
                                <td>
                                    <span class="badge bg-info-subtle text-info"><?php echo e($permission->roles->count()); ?></span>
                                </td>
                                <td class="text-end">
                                    <a href="<?php echo e(route('admin.permissions.edit', $permission)); ?>" class="btn btn-sm btn-outline-primary"><?php echo e(__('app.permissions.edit')); ?></a>
                                    <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($permission->id); ?>"><?php echo e(__('app.permissions.delete')); ?></button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php $__currentLoopData = $permissions->flatten(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal<?php echo e($permission->id); ?>" tabindex="-1" aria-labelledby="deleteModalLabel<?php echo e($permission->id); ?>" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header border-0 pb-0">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center px-4 pb-4">
                        <div class="mb-3">
                            <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 64px; height: 64px;">
                                <i class="bi bi-exclamation-triangle-fill text-danger fs-2"></i>
                            </div>
                        </div>
                        <h5 class="modal-title fw-bold mb-2" id="deleteModalLabel<?php echo e($permission->id); ?>"><?php echo e(__('app.permissions.delete_confirm')); ?></h5>
                        <p class="text-muted mb-0">
                            <?php echo e(__('app.permissions.table.display_name')); ?>: <strong><?php echo e($permission->display_name); ?></strong>
                        </p>
                    </div>
                    <div class="modal-footer border-0 justify-content-center gap-2 pb-4">
                        <button type="button" class="btn btn-outline-secondary btn-rounded" data-bs-dismiss="modal">
                            <?php echo e(__('app.permissions.form.cancel')); ?>

                        </button>
                        <form action="<?php echo e(route('admin.permissions.destroy', $permission)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-rounded">
                                <i class="bi bi-trash me-2"></i><?php echo e(__('app.permissions.delete')); ?>

                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>





<?php echo $__env->make('layouts.admin', ['title' => __('app.permissions.title')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Lavandera\resources\views/admin/permissions/index.blade.php ENDPATH**/ ?>