<?php

use App\Http\Controllers\Admin\CashboxController;
use App\Http\Controllers\Admin\ClothingItemController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ServiceOrderController as AdminServiceOrderController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\TransactionController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\LicenseController;
use App\Http\Controllers\TrialController;
use App\Http\Controllers\ServiceOrderController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth'])->group(function () {
    Route::get('/', [ServiceOrderController::class, 'index'])->name('service-orders.index');
    Route::post('/service-orders', [ServiceOrderController::class, 'store'])->name('service-orders.store');
    Route::get('/service-orders/{serviceOrder}/receipt', [ServiceOrderController::class, 'receipt'])->name('service-orders.receipt');
    Route::post('/service-orders/barcode', [ServiceOrderController::class, 'lookupByBarcode'])->name('service-orders.lookup');
    Route::post('/service-orders/{serviceOrder}/collected', [ServiceOrderController::class, 'markCollected'])->name('service-orders.collected');
    Route::get('/api/items/search', [ServiceOrderController::class, 'searchItems'])->name('items.search');
});

Route::post('/locale', function (Request $request) {
    $available = config('app.available_locales', ['en']);
    $data = $request->validate([
        'locale' => ['required', 'in:' . implode(',', $available)],
    ]);

    session(['locale' => $data['locale']]);

    return back();
})->name('locale.switch');

// Trial Routes
Route::get('trial/expired', [TrialController::class, 'expired'])->name('trial.expired');
Route::get('trial/test', [TrialController::class, 'test'])->name('trial.test');
Route::post('trial/test/set/{days}', [TrialController::class, 'setTestDate'])->name('trial.test.set');

// License Routes
Route::prefix('license')->name('license.')->group(function () {
    Route::get('activate', [LicenseController::class, 'showActivationForm'])->name('activate');
    Route::post('activate', [LicenseController::class, 'activate']);
});

// Authentication routes
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Protected admin routes
Route::prefix('admin')->name('admin.')->middleware(['auth'])->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->middleware('permission:view_dashboard')->name('dashboard');

    // Users management
    Route::resource('users', \App\Http\Controllers\Admin\UserController::class)->middleware('permission:manage_users');
    
    // Roles & Permissions
    Route::resource('roles', \App\Http\Controllers\Admin\RoleController::class)->middleware('permission:manage_roles');
    Route::resource('permissions', \App\Http\Controllers\Admin\PermissionController::class)->middleware('permission:manage_permissions');

    // Items management
    Route::resource('items', ClothingItemController::class)->middleware('permission:manage_items');
    
    // Orders management
    Route::resource('orders', AdminServiceOrderController::class)->middleware('permission:view_orders');
    
    // Transactions
    Route::resource('transactions', TransactionController::class)->middleware('permission:view_transactions');
    
    // Cashboxes
    Route::resource('cashboxes', CashboxController::class)->middleware('permission:view_cashboxes');
    Route::delete('cashboxes/{cashbox}/entries/{entry}', [CashboxController::class, 'destroyEntry'])->name('cashboxes.entries.destroy')->middleware('permission:manage_transactions');

    // Settings
    Route::get('settings', [SettingController::class, 'edit'])->middleware('permission:view_settings')->name('settings.edit');
    Route::post('settings', [SettingController::class, 'update'])->middleware('permission:manage_settings')->name('settings.update');
});
