@extends('layouts.app', ['title' => __('app.trial.test_title')])

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="masbana-card p-5">
                <div class="text-center mb-4">
                    <div class="bg-primary-subtle rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="bi bi-clipboard-check text-primary fs-1"></i>
                    </div>
                    <h2 class="fw-bold mb-2">{{ __('app.trial.test_title') }}</h2>
                    <p class="text-muted">{{ __('app.trial.test_subtitle') }}</p>
                </div>

                <!-- Trial Information Cards -->
                <div class="row g-4 mb-4">
                    <!-- Trial Status -->
                    <div class="col-md-6">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-body">
                                <h5 class="card-title fw-bold mb-3">
                                    <i class="bi bi-calendar-check me-2"></i>{{ __('app.trial.trial_info') }}
                                </h5>
                                <table class="table table-borderless mb-0">
                                    <tr>
                                        <td class="fw-semibold text-muted">{{ __('app.trial.start_date') }}:</td>
                                        <td><strong>{{ $startDate->format('Y-m-d H:i:s') }}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold text-muted">{{ __('app.trial.end_date') }}:</td>
                                        <td><strong>{{ $endDate->format('Y-m-d H:i:s') }}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold text-muted">{{ __('app.trial.total_days') }}:</td>
                                        <td><strong>{{ $trialInfo['total_days'] }} {{ __('app.trial.days') }}</strong></td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold text-muted">{{ __('app.trial.days_remaining') }}:</td>
                                        <td>
                                            <span class="badge {{ $daysRemaining > 3 ? 'bg-success' : ($daysRemaining > 0 ? 'bg-warning' : 'bg-danger') }} fs-6">
                                                {{ $daysRemaining }} {{ __('app.trial.days') }}
                                            </span>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Trial Status -->
                    <div class="col-md-6">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-body">
                                <h5 class="card-title fw-bold mb-3">
                                    <i class="bi bi-info-circle me-2"></i>{{ __('app.trial.status') }}
                                </h5>
                                <div class="mb-3">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="fw-semibold">{{ __('app.trial.is_expired') }}:</span>
                                        <span class="badge {{ $isExpired ? 'bg-danger' : 'bg-success' }} fs-6">
                                            {{ $isExpired ? __('app.trial.yes') : __('app.trial.no') }}
                                        </span>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="fw-semibold">{{ __('app.trial.is_expiring_soon') }}:</span>
                                        <span class="badge {{ $isExpiringSoon ? 'bg-warning' : 'bg-secondary' }} fs-6">
                                            {{ $isExpiringSoon ? __('app.trial.yes') : __('app.trial.no') }}
                                        </span>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="fw-semibold">{{ __('app.trial.current_date') }}:</span>
                                        <span class="text-muted small">{{ now()->format('Y-m-d H:i:s') }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- License Information -->
                @php
                    $licenseService = app(\App\Services\LicenseService::class);
                    $licenseInfo = $licenseService->getLicenseInfo();
                    $hasLicense = $licenseService->verifyLocal();
                @endphp

                @if($hasLicense && $licenseInfo)
                <div class="card border-0 shadow-sm mb-4 border-success">
                    <div class="card-body">
                        <h5 class="card-title fw-bold mb-3 text-success">
                            <i class="bi bi-shield-check me-2"></i>{{ __('app.license.license_info') }}
                        </h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="d-flex justify-content-between">
                                    <span class="fw-semibold text-muted">{{ __('app.license.license_key') }}:</span>
                                    <span class="text-muted">{{ $licenseInfo['license_key'] ?? 'N/A' }}</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex justify-content-between">
                                    <span class="fw-semibold text-muted">{{ __('app.license.serial_number') }}:</span>
                                    <span class="text-muted">{{ $licenseInfo['serial_number'] ?? 'N/A' }}</span>
                                </div>
                            </div>
                            @if($licenseInfo['customer_name'])
                            <div class="col-md-6">
                                <div class="d-flex justify-content-between">
                                    <span class="fw-semibold text-muted">{{ __('app.license.customer_name') }}:</span>
                                    <span class="text-muted">{{ $licenseInfo['customer_name'] }}</span>
                                </div>
                            </div>
                            @endif
                            @if($licenseInfo['email'])
                            <div class="col-md-6">
                                <div class="d-flex justify-content-between">
                                    <span class="fw-semibold text-muted">{{ __('app.license.email') }}:</span>
                                    <span class="text-muted">{{ $licenseInfo['email'] }}</span>
                                </div>
                            </div>
                            @endif
                            @if($licenseInfo['expires_at'])
                            <div class="col-md-6">
                                <div class="d-flex justify-content-between">
                                    <span class="fw-semibold text-muted">{{ __('app.license.expires_at') }}:</span>
                                    <span class="text-muted">{{ $licenseInfo['expires_at'] }}</span>
                                </div>
                            </div>
                            @endif
                            @if($licenseInfo['days_remaining'] !== null)
                            <div class="col-md-6">
                                <div class="d-flex justify-content-between">
                                    <span class="fw-semibold text-muted">{{ __('app.trial.days_remaining') }}:</span>
                                    <span class="badge {{ $licenseInfo['days_remaining'] > 30 ? 'bg-success' : ($licenseInfo['days_remaining'] > 0 ? 'bg-warning' : 'bg-danger') }}">
                                        {{ $licenseInfo['days_remaining'] }} {{ __('app.trial.days') }}
                                    </span>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                @else
                <div class="alert alert-warning rounded-4 mb-4">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-exclamation-triangle me-2 fs-4"></i>
                        <div>
                            <strong>{{ __('app.trial.no_license') }}</strong>
                            <p class="mb-0 small">{{ __('app.trial.activate_to_continue') }}</p>
                        </div>
                    </div>
                </div>
                @endif

                <!-- Detailed JSON Info -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <h5 class="card-title fw-bold mb-3">
                            <i class="bi bi-code-square me-2"></i>{{ __('app.trial.detailed_info') }}
                        </h5>
                        <pre class="bg-light p-3 rounded-4 mb-0" style="font-size: 0.85rem; max-height: 300px; overflow-y: auto;">{{ json_encode($trialInfo, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) }}</pre>
                    </div>
                </div>

                <!-- Test Buttons -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <h5 class="card-title fw-bold mb-3">
                            <i class="bi bi-sliders me-2"></i>{{ __('app.trial.test_buttons') }}
                        </h5>
                        <p class="text-muted small mb-3">{{ __('app.trial.test_buttons_desc') }}</p>
                        <div class="d-grid gap-2 d-md-flex">
                            <form action="{{ route('trial.test.set', 18) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-warning btn-rounded">
                                    <i class="bi bi-clock-history me-2"></i>{{ __('app.trial.set_18_days') }}
                                </button>
                            </form>
                            <form action="{{ route('trial.test.set', 21) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-success btn-rounded">
                                    <i class="bi bi-arrow-clockwise me-2"></i>{{ __('app.trial.set_21_days') }}
                                </button>
                            </form>
                            <form action="{{ route('trial.test.set', 0) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-dark btn-rounded">
                                    <i class="bi bi-ban me-2"></i>{{ __('app.trial.set_0_days') }}
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show rounded-4" role="alert">
                        <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <!-- Action Buttons -->
                <div class="d-grid gap-2 d-md-flex justify-content-center">
                    <a href="{{ route('trial.expired') }}" class="btn btn-outline-danger btn-rounded">
                        <i class="bi bi-exclamation-triangle me-2"></i>{{ __('app.trial.view_expired') }}
                    </a>
                    <a href="{{ route('license.activate') }}" class="btn btn-primary btn-rounded">
                        <i class="bi bi-key-fill me-2"></i>{{ __('app.trial.activate_license') }}
                    </a>
                    @auth
                    <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary btn-rounded">
                        <i class="bi bi-arrow-left me-2"></i>{{ __('app.trial.back_to_dashboard') }}
                    </a>
                    @else
                    <a href="{{ route('login') }}" class="btn btn-outline-secondary btn-rounded">
                        <i class="bi bi-arrow-left me-2"></i>{{ __('app.trial.back_to_login') }}
                    </a>
                    @endauth
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
