@extends('layouts.app', ['title' => __('app.trial.expired_title')])

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6">
            <div class="masbana-card p-5 text-center">
                <!-- Icon -->
                <div class="mb-4">
                    <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 100px; height: 100px;">
                        <i class="bi bi-exclamation-triangle-fill text-danger" style="font-size: 3rem;"></i>
                    </div>
                    <h2 class="fw-bold mb-3">{{ __('app.trial.expired_title') }}</h2>
                    <p class="text-muted fs-5 mb-4">{{ __('app.trial.expired_message') }}</p>
                </div>

                <!-- Trial Information -->
                <div class="alert alert-info mb-4 rounded-4">
                    <div class="d-flex align-items-start">
                        <i class="bi bi-info-circle me-3 fs-4"></i>
                        <div class="text-start flex-grow-1">
                            <strong class="d-block mb-2">{{ __('app.trial.trial_info') }}</strong>
                            <ul class="mb-0">
                                <li>{{ __('app.trial.start_date') }}: <strong>{{ $trialInfo['start_date'] }}</strong></li>
                                <li>{{ __('app.trial.end_date') }}: <strong>{{ $trialInfo['end_date'] }}</strong></li>
                                <li>{{ __('app.trial.total_days') }}: <strong>{{ $trialInfo['total_days'] }} {{ __('app.trial.days') }}</strong></li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="d-grid gap-2 mb-4">
                    <a href="{{ route('license.activate') }}" class="btn btn-primary btn-lg btn-rounded">
                        <i class="bi bi-key-fill me-2"></i>{{ __('app.trial.activate_license') }}
                    </a>
                    <a href="{{ route('login') }}" class="btn btn-outline-secondary btn-rounded">
                        <i class="bi bi-arrow-left me-2"></i>{{ __('app.trial.back_to_login') }}
                    </a>
                </div>

                <!-- Support Information -->
                <div class="mt-5 pt-4 border-top">
                    <p class="text-muted small mb-2">{{ __('app.trial.contact_support') }}</p>
                    <p class="mb-0">
                        <a href="mailto:{{ __('app.footer.email') }}" class="text-decoration-none">
                            <i class="bi bi-envelope me-2"></i>{{ __('app.footer.email') }}
                        </a>
                    </p>
                    <p class="mb-0 mt-2">
                        <a href="tel:{{ str_replace(' ', '', __('app.footer.phone')) }}" class="text-decoration-none">
                            <i class="bi bi-telephone me-2"></i>{{ __('app.footer.phone') }}
                        </a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
