@extends('layouts.app')

@section('title', trim(($title ?? __('app.admin.dashboard')) . ' · ' . __('app.brand')))

@section('content')
    <div class="row g-4">
        <div class="col-12">
            <div class="masbana-card p-4">
                <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3">
                    <div>
                        <p class="heading-label mb-1">{{ __('app.tagline') }}</p>
                        <h1 class="h3 fw-bold m-0">{{ $title ?? __('app.admin.dashboard') }}</h1>
                    </div>
                    <div class="d-flex flex-wrap gap-2">
                        <a href="{{ route('service-orders.index') }}" class="btn btn-outline-primary btn-rounded">
                            <i class="bi bi-plus-circle me-2"></i>{{ __('app.admin.quick_actions.new_service') }}
                        </a>
                        <a href="{{ route('admin.settings.edit') }}" class="btn btn-primary btn-rounded">
                            <i class="bi bi-gear me-2"></i>{{ __('app.admin.quick_actions.settings') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        @auth
            <div class="col-12">
                <div class="alert alert-info rounded-4 mb-0 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center gap-2">
                        <i class="bi bi-person-circle fs-5"></i>
                        <div>
                            <div class="fw-semibold">{{ auth()->user()->name }}</div>
                            <small class="text-muted">{{ auth()->user()->email }} 
                                @if(auth()->user()->role)
                                    · {{ auth()->user()->role->display_name }}
                                @endif
                            </small>
                        </div>
                    </div>
                    <form action="{{ route('logout') }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-sm btn-outline-danger btn-rounded">
                            <i class="bi bi-box-arrow-right me-1"></i>{{ __('app.auth.logout') }}
                        </button>
                    </form>
                </div>
            </div>
        @endauth

        @php
            $trialService = app(\App\Services\TrialService::class);
            $licenseService = app(\App\Services\LicenseService::class);
            $hasLicense = $licenseService->verifyLocal();
            $trialInfo = $trialService->getTrialInfo();
        @endphp

        @if(!$hasLicense && $trialInfo['is_expiring_soon'])
            <div class="col-12">
                <div class="trial-warning-notification mb-0">
                    <div class="d-flex align-items-start gap-3">
                        <div class="trial-warning-icon">
                            <i class="bi bi-exclamation-triangle-fill"></i>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-2">
                                <h6 class="fw-bold mb-0">
                                    <i class="bi bi-clock-history me-2"></i>{{ __('app.trial.warning_title') }}
                                </h6>
                                <span class="badge bg-warning-subtle text-warning-emphasis px-3 py-2">
                                    <i class="bi bi-calendar-x me-1"></i>{{ $trialInfo['days_remaining'] }} {{ __('app.trial.days') }} {{ __('app.trial.remaining') }}
                                </span>
                            </div>
                            <p class="mb-3 text-muted">{{ __('app.trial.warning_message', ['days' => $trialInfo['days_remaining']]) }}</p>
                            <div class="d-flex gap-2 flex-wrap">
                                <a href="{{ route('license.activate') }}" class="btn btn-warning btn-sm btn-rounded">
                                    <i class="bi bi-key-fill me-2"></i>{{ __('app.trial.activate_license') }}
                                </a>
                                <button type="button" class="btn btn-outline-secondary btn-sm btn-rounded" onclick="this.closest('.trial-warning-notification').style.display='none'">
                                    <i class="bi bi-x-lg me-1"></i>{{ __('app.trial.dismiss') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <div class="col-12 col-lg-3">
            <div class="masbana-card p-3 h-100">
                <div class="list-group list-group-flush">
                    <a href="{{ route('admin.dashboard') }}" class="list-group-item list-group-item-action {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                        <i class="bi bi-speedometer me-2"></i> {{ __('app.admin.dashboard') }}
                    </a>
                    @can('view_orders')
                        <a href="{{ route('admin.orders.index') }}" class="list-group-item list-group-item-action {{ request()->routeIs('admin.orders.*') ? 'active' : '' }}">
                            <i class="bi bi-receipt-cutoff me-2"></i> {{ __('app.admin.orders') }}
                        </a>
                    @endcan
                    @can('view_items')
                        <a href="{{ route('admin.items.index') }}" class="list-group-item list-group-item-action {{ request()->routeIs('admin.items.*') ? 'active' : '' }}">
                            <i class="bi bi-bag-check me-2"></i> {{ __('app.admin.items') }}
                        </a>
                    @endcan
                    @can('view_transactions')
                        <a href="{{ route('admin.transactions.index') }}" class="list-group-item list-group-item-action {{ request()->routeIs('admin.transactions.*') ? 'active' : '' }}">
                            <i class="bi bi-cash-stack me-2"></i> {{ __('app.admin.transactions') }}
                        </a>
                    @endcan
                    @can('view_cashboxes')
                        <a href="{{ route('admin.cashboxes.index') }}" class="list-group-item list-group-item-action {{ request()->routeIs('admin.cashboxes.*') ? 'active' : '' }}">
                            <i class="bi bi-safe2 me-2"></i> {{ __('app.admin.cashbox') }}
                        </a>
                    @endcan
                    @can('view_users')
                        <a href="{{ route('admin.users.index') }}" class="list-group-item list-group-item-action {{ request()->routeIs('admin.users.*') ? 'active' : '' }}">
                            <i class="bi bi-people me-2"></i> {{ __('app.admin.users') }}
                        </a>
                    @endcan
                    @can('view_roles')
                        <a href="{{ route('admin.roles.index') }}" class="list-group-item list-group-item-action {{ request()->routeIs('admin.roles.*') ? 'active' : '' }}">
                            <i class="bi bi-shield-check me-2"></i> {{ __('app.admin.roles') }}
                        </a>
                    @endcan
                    @can('manage_permissions')
                        <a href="{{ route('admin.permissions.index') }}" class="list-group-item list-group-item-action {{ request()->routeIs('admin.permissions.*') ? 'active' : '' }}">
                            <i class="bi bi-key me-2"></i> {{ __('app.admin.permissions') }}
                        </a>
                    @endcan
                    @can('view_settings')
                        <a href="{{ route('admin.settings.edit') }}" class="list-group-item list-group-item-action {{ request()->routeIs('admin.settings.*') ? 'active' : '' }}">
                            <i class="bi bi-gear me-2"></i> {{ __('app.admin.settings') }}
                        </a>
                    @endcan
                </div>
            </div>
        </div>

        <div class="col-12 col-lg-9">
            <div class="masbana-card p-4">
                @yield('admin-content')
            </div>
        </div>
    </div>
@endsection

