@extends('layouts.app')

@section('title', __('app.auth.login') . ' · ' . __('app.brand'))

@section('content')
    <div class="container">
        <div class="row justify-content-center align-items-center" style="min-height: calc(100vh - 200px);">
            <div class="col-12 col-md-6 col-lg-4">
                <div class="masbana-card p-4">
                    <div class="text-center mb-4">
                        <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width:64px;height:64px;background:var(--masbana-sky);">
                            <i class="bi bi-droplet text-white fs-3"></i>
                        </div>
                        <h3 class="fw-bold mb-1">{{ __('app.brand') }}</h3>
                        <p class="text-muted small mb-0">{{ __('app.auth.login_description') }}</p>
                    </div>

                    @if (session('status'))
                        <div class="alert alert-success alert-dismissible fade show rounded-4" role="alert">
                            {{ session('status') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible fade show rounded-4" role="alert">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('login') }}">
                        @csrf

                        <div class="mb-3">
                            <label for="email" class="form-label fw-semibold">{{ __('app.auth.email') }}</label>
                            <input type="email" class="form-control form-control-lg rounded-4 @error('email') is-invalid @enderror" 
                                   id="email" name="email" value="{{ old('email') }}" required autofocus>
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="password" class="form-label fw-semibold">{{ __('app.auth.password') }}</label>
                            <input type="password" class="form-control form-control-lg rounded-4 @error('password') is-invalid @enderror" 
                                   id="password" name="password" required>
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                <label class="form-check-label" for="remember">
                                    {{ __('app.auth.remember_me') }}
                                </label>
                            </div>
                        </div>

                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary btn-rounded btn-lg">
                                <i class="bi bi-box-arrow-in-right me-2"></i>{{ __('app.auth.login') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection




