@extends('layouts.admin', ['title' => __('app.transactions.show_title')])

@section('admin-content')
    <div class="mb-4">
        <h4 class="fw-bold mb-1">{{ $transaction->type === 'income' ? __('app.transactions.income') : __('app.transactions.expense') }} · {{ $transaction->category }}</h4>
        <div class="{{ $transaction->type === 'income' ? 'text-success' : 'text-danger' }} fw-bold fs-4">
            {{ $transaction->type === 'income' ? '+' : '-' }}{{ number_format($transaction->amount, 2) }}
        </div>
        <p class="text-muted mb-0">{{ __('app.transactions.date') }}: {{ \Illuminate\Support\Carbon::parse($transaction->occurred_on)->format('d M Y') }}</p>
        <p class="text-muted">{{ __('app.transactions.cashbox') }}: {{ $transaction->cashbox->name ?? '—' }}</p>
    </div>

    <p>{{ $transaction->description }}</p>

    <div class="d-flex gap-2">
        @if (! $transaction->reference_type)
            <a href="{{ route('admin.transactions.edit', $transaction) }}" class="btn btn-primary btn-rounded">{{ __('app.transactions.edit') }}</a>
            <form action="{{ route('admin.transactions.destroy', $transaction) }}" method="POST" onsubmit="return confirm('{{ __('app.transactions.delete_confirm') }}')">
                @csrf
                @method('DELETE')
                <button class="btn btn-outline-danger btn-rounded" type="submit">{{ __('app.transactions.delete') }}</button>
            </form>
        @else
            <span class="badge bg-secondary-subtle text-secondary">{{ __('app.transactions.locked') }}</span>
        @endif
        <a href="{{ route('admin.transactions.index') }}" class="btn btn-outline-secondary btn-rounded">{{ __('app.transactions.back') }}</a>
    </div>
@endsection

