@extends('layouts.admin', ['title' => __('app.roles.title')])

@section('admin-content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0">{{ __('app.roles.title') }}</h4>
            <p class="text-muted small mb-0">{{ __('app.roles.description') }}</p>
        </div>
        <a href="{{ route('admin.roles.create') }}" class="btn btn-primary btn-rounded">
            <i class="bi bi-plus-lg me-2"></i>{{ __('app.roles.new_role') }}
        </a>
    </div>

    <div class="table-responsive">
        <table class="table align-middle">
            <thead>
                <tr>
                    <th>{{ __('app.roles.table.name') }}</th>
                    <th>{{ __('app.roles.table.display_name') }}</th>
                    <th>{{ __('app.roles.table.users_count') }}</th>
                    <th>{{ __('app.roles.table.permissions_count') }}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @foreach ($roles as $role)
                    <tr>
                        <td>
                            <code class="text-primary">{{ $role->name }}</code>
                        </td>
                        <td class="fw-semibold">{{ $role->display_name }}</td>
                        <td>
                            <span class="badge bg-info-subtle text-info">{{ $role->users_count }}</span>
                        </td>
                        <td>
                            <span class="badge bg-success-subtle text-success">{{ $role->permissions->count() }}</span>
                        </td>
                        <td class="text-end">
                            <a href="{{ route('admin.roles.edit', $role) }}" class="btn btn-sm btn-outline-primary">{{ __('app.roles.edit') }}</a>
                            @if(!in_array($role->name, ['admin', 'manager', 'cashier']))
                                <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $role->id }}">{{ __('app.roles.delete') }}</button>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    @foreach ($roles as $role)
        @if(!in_array($role->name, ['admin', 'manager', 'cashier']))
            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="deleteModal{{ $role->id }}" tabindex="-1" aria-labelledby="deleteModalLabel{{ $role->id }}" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header border-0 pb-0">
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body text-center px-4 pb-4">
                            <div class="mb-3">
                                <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 64px; height: 64px;">
                                    <i class="bi bi-exclamation-triangle-fill text-danger fs-2"></i>
                                </div>
                            </div>
                            <h5 class="modal-title fw-bold mb-2" id="deleteModalLabel{{ $role->id }}">{{ __('app.roles.delete_confirm') }}</h5>
                            <p class="text-muted mb-0">
                                {{ __('app.roles.table.display_name') }}: <strong>{{ $role->display_name }}</strong>
                            </p>
                        </div>
                        <div class="modal-footer border-0 justify-content-center gap-2 pb-4">
                            <button type="button" class="btn btn-outline-secondary btn-rounded" data-bs-dismiss="modal">
                                {{ __('app.roles.form.cancel') }}
                            </button>
                            <form action="{{ route('admin.roles.destroy', $role) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-rounded">
                                    <i class="bi bi-trash me-2"></i>{{ __('app.roles.delete') }}
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    @endforeach
@endsection




