@extends('layouts.admin', ['title' => __('app.roles.edit_title')])

@section('admin-content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0">{{ __('app.roles.edit_role') }}</h4>
            <p class="text-muted small mb-0">{{ __('app.roles.edit_description') }}</p>
        </div>
        <a href="{{ route('admin.roles.index') }}" class="btn btn-outline-secondary btn-rounded">
            <i class="bi bi-arrow-left me-2"></i>{{ __('app.roles.back') }}
        </a>
    </div>

    <form action="{{ route('admin.roles.update', $role) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="row g-3">
            <div class="col-12 col-md-6">
                <label for="name" class="form-label fw-semibold">{{ __('app.roles.form.name') }}</label>
                <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $role->name) }}" required>
                <small class="text-muted">{{ __('app.roles.form.name_hint') }}</small>
                @error('name')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-12 col-md-6">
                <label for="display_name" class="form-label fw-semibold">{{ __('app.roles.form.display_name') }}</label>
                <input type="text" class="form-control @error('display_name') is-invalid @enderror" id="display_name" name="display_name" value="{{ old('display_name', $role->display_name) }}" required>
                @error('display_name')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-12">
                <label for="description" class="form-label fw-semibold">{{ __('app.roles.form.description') }}</label>
                <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description', $role->description) }}</textarea>
                @error('description')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-12">
                <label class="form-label fw-semibold mb-3">{{ __('app.roles.form.permissions') }}</label>
                <div class="border rounded p-3" style="max-height: 400px; overflow-y: auto;">
                    @foreach($permissions as $group => $groupPermissions)
                        <div class="mb-4">
                            <h6 class="fw-semibold text-primary mb-2">{{ $group ?: __('app.roles.other') }}</h6>
                            <div class="row g-2">
                                @foreach($groupPermissions as $permission)
                                    <div class="col-12 col-md-6 col-lg-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="{{ $permission->id }}" id="permission{{ $permission->id }}" {{ in_array($permission->id, old('permissions', $role->permissions->pluck('id')->toArray())) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="permission{{ $permission->id }}">
                                                {{ $permission->display_name }}
                                                @if($permission->description)
                                                    <small class="text-muted d-block">{{ $permission->description }}</small>
                                                @endif
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <div class="col-12">
                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary btn-rounded">
                        <i class="bi bi-check-lg me-2"></i>{{ __('app.roles.form.save') }}
                    </button>
                    <a href="{{ route('admin.roles.index') }}" class="btn btn-outline-secondary btn-rounded">
                        {{ __('app.roles.form.cancel') }}
                    </a>
                </div>
            </div>
        </div>
    </form>
@endsection




