@csrf
<div class="row g-3">
    <div class="col-md-6">
        <label class="form-label fw-semibold">{{ __('app.items.form.name') }}</label>
        <input type="text" name="name" class="form-control rounded-4" value="{{ old('name', $clothingItem->name ?? '') }}" required>
    </div>
    <div class="col-md-6">
        <label class="form-label fw-semibold">{{ __('app.items.form.slug') }}</label>
        <input type="text" name="slug" class="form-control rounded-4" value="{{ old('slug', $clothingItem->slug ?? '') }}" placeholder="{{ __('app.items.form.slug_placeholder') }}">
    </div>
    <div class="col-md-12">
        <label class="form-label fw-semibold">{{ __('app.items.form.image') }}</label>
        @if(isset($clothingItem) && $clothingItem->image_path)
            <div class="mb-2">
                <img src="{{ $clothingItem->image_url }}" alt="{{ $clothingItem->name }}" class="img-thumbnail rounded-4" style="max-height: 150px;">
            </div>
        @endif
        <input type="file" name="image" class="form-control rounded-4" accept="image/*" {{ !isset($clothingItem) || !$clothingItem->image_path ? 'required' : '' }}>
        <small class="text-muted">{{ __('app.items.form.image_hint') }}</small>
    </div>
    <div class="col-md-6">
        <label class="form-label fw-semibold">{{ __('app.items.form.washing_price') }}</label>
        <input type="number" step="0.5" min="0" name="default_wash_price" class="form-control rounded-4" value="{{ old('default_wash_price', $clothingItem->default_wash_price ?? 0) }}" required>
    </div>
    <div class="col-md-6">
        <label class="form-label fw-semibold">{{ __('app.items.form.ironing_price') }}</label>
        <input type="number" step="0.5" min="0" name="default_iron_price" class="form-control rounded-4" value="{{ old('default_iron_price', $clothingItem->default_iron_price ?? 0) }}" required>
    </div>
    <div class="col-12 form-check form-switch ps-0">
        <input type="checkbox" class="form-check-input" id="isActive" name="is_active" value="1" {{ old('is_active', $clothingItem->is_active ?? true) ? 'checked' : '' }}>
        <label class="form-check-label fw-semibold" for="isActive">{{ __('app.items.form.active') }}</label>
    </div>
</div>
<div class="mt-4 d-flex gap-2">
    <button class="btn btn-primary btn-rounded" type="submit">
        <i class="bi bi-save me-2"></i>{{ __('app.items.form.save') }}
    </button>
    <a href="{{ route('admin.items.index') }}" class="btn btn-outline-secondary btn-rounded">{{ __('app.items.form.cancel') }}</a>
</div>


