@extends('layouts.admin', ['title' => __('app.admin.dashboard')])

@section('admin-content')

    <div class="row g-4">
        <div class="col-md-4">
            <div class="border rounded-4 p-3 bg-light">
                <p class="heading-label mb-1">{{ __('app.dashboard_cards.processing') }}</p>
                <div class="display-6 fw-bold">{{ $stats['processing_orders'] }}</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded-4 p-3 bg-light">
                <p class="heading-label mb-1">{{ __('app.dashboard_cards.ready') }}</p>
                <div class="display-6 fw-bold">{{ $stats['ready_orders'] }}</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded-4 p-3 bg-light">
                <p class="heading-label mb-1">{{ __('app.dashboard_cards.collected') }}</p>
                <div class="display-6 fw-bold">{{ $stats['collected_today'] }}</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded-4 p-3">
                <p class="heading-label mb-1">{{ __('app.dashboard_cards.revenue') }}</p>
                <div class="display-6 fw-bold text-success">{{ number_format($stats['revenue_today'], 2) }}</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded-4 p-3">
                <p class="heading-label mb-1">{{ __('app.dashboard_cards.expenses') }}</p>
                <div class="display-6 fw-bold text-danger">{{ number_format($stats['expenses_today'], 2) }}</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="border rounded-4 p-3">
                <p class="heading-label mb-1">{{ __('app.dashboard_cards.cashbox') }}</p>
                <div class="display-6 fw-bold">{{ number_format($stats['cashbox_balance'], 2) }}</div>
            </div>
        </div>
    </div>

    <div class="row g-4 mt-1">
        <div class="col-lg-6">
            <h5 class="fw-bold mb-3">{{ __('app.dashboard_cards.recent_orders') }}</h5>
            <div class="list-group">
                @forelse ($recentOrders as $order)
                    <a href="{{ route('admin.orders.show', $order) }}" class="list-group-item list-group-item-action d-flex justify-content-between">
                        <div>
                            <div class="fw-semibold">{{ $order->order_number }}</div>
                            <small class="text-muted">{{ ucfirst($order->service_type) }} · {{ trans_choice('app.orders.items_count', $order->items->count(), ['count' => $order->items->count()]) }}</small>
                        </div>
                        <div class="text-end">
                            <div class="fw-bold">{{ number_format($order->total, 2) }}</div>
                            <small class="text-muted">{{ ucfirst($order->status) }}</small>
                        </div>
                    </a>
                @empty
                    <div class="text-muted">{{ __('app.dashboard_cards.orders_empty') }}</div>
                @endforelse
            </div>
        </div>
        <div class="col-lg-6">
            <h5 class="fw-bold mb-3">{{ __('app.dashboard_cards.recent_transactions') }}</h5>
            <div class="list-group">
                @forelse ($recentTransactions as $transaction)
                    <div class="list-group-item d-flex justify-content-between">
                        <div>
                            <div class="fw-semibold text-capitalize">{{ $transaction->type }} · {{ $transaction->category }}</div>
                            <small class="text-muted">{{ \Illuminate\Support\Carbon::parse($transaction->occurred_on)->format('d M Y') }}</small>
                        </div>
                        <div class="fw-bold {{ $transaction->type === 'income' ? 'text-success' : 'text-danger' }}">
                            {{ $transaction->type === 'income' ? '+' : '-' }}{{ number_format($transaction->amount, 2) }}
                        </div>
                    </div>
                @empty
                    <div class="text-muted">{{ __('app.dashboard_cards.transactions_empty') }}</div>
                @endforelse
            </div>
        </div>
    </div>
@endsection

