@extends('layouts.admin', ['title' => $cashbox->name])

@section('admin-content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-1">{{ $cashbox->name }}</h4>
            <p class="text-muted mb-0">{{ __('app.cashboxes.show.balance') }}: {{ number_format($cashbox->current_balance, 2) }}</p>
        </div>
        <a href="{{ route('admin.cashboxes.edit', $cashbox) }}" class="btn btn-outline-primary btn-rounded">{{ __('app.cashboxes.show.edit') }}</a>
    </div>

    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>{{ __('app.cashboxes.show.date') }}</th>
                    <th>{{ __('app.cashboxes.show.direction') }}</th>
                    <th>{{ __('app.cashboxes.show.amount') }}</th>
                    <th>{{ __('app.cashboxes.show.balance') }}</th>
                    @can('manage_transactions')
                        <th class="text-end">{{ __('app.cashboxes.show.actions') }}</th>
                    @endcan
                </tr>
            </thead>
            <tbody>
                @forelse ($cashbox->entries as $entry)
                    <tr>
                        <td>{{ $entry->created_at->format('d M Y H:i') }}</td>
                        <td class="text-capitalize">{{ $entry->direction === 'in' ? __('app.cashboxes.show.in') : __('app.cashboxes.show.out') }}</td>
                        <td class="{{ $entry->direction === 'in' ? 'text-success' : 'text-danger' }}">
                            {{ $entry->direction === 'in' ? '+' : '-' }}{{ number_format($entry->amount, 2) }}
                        </td>
                        <td>{{ number_format($entry->running_balance, 2) }}</td>
                        @can('manage_transactions')
                            <td class="text-end">
                                <button type="button" class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $entry->id }}">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </td>
                        @endcan
                    </tr>
                @empty
                    <tr>
                        <td colspan="{{ auth()->user()->hasPermission('manage_transactions') ? '5' : '4' }}" class="text-center text-muted py-5">{{ __('app.cashboxes.show.none') }}</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @can('manage_transactions')
        @foreach ($cashbox->entries as $entry)
            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="deleteModal{{ $entry->id }}" tabindex="-1" aria-labelledby="deleteModalLabel{{ $entry->id }}" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header border-0 pb-0">
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body text-center px-4 pb-4">
                            <div class="mb-3">
                                <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 64px; height: 64px;">
                                    <i class="bi bi-exclamation-triangle-fill text-danger fs-2"></i>
                                </div>
                            </div>
                            <h5 class="modal-title fw-bold mb-2" id="deleteModalLabel{{ $entry->id }}">{{ __('app.cashboxes.show.delete_confirm') }}</h5>
                            <p class="text-muted mb-0">
                                {{ __('app.cashboxes.show.direction') }}: <strong>{{ $entry->direction === 'in' ? __('app.cashboxes.show.in') : __('app.cashboxes.show.out') }}</strong><br>
                                {{ __('app.cashboxes.show.amount') }}: <strong>{{ number_format($entry->amount, 2) }}</strong><br>
                                {{ __('app.cashboxes.show.date') }}: <strong>{{ $entry->created_at->format('d M Y H:i') }}</strong>
                                @if($entry->transaction && $entry->transaction->reference_type)
                                    <br><span class="badge bg-warning-subtle text-warning mt-2">{{ __('app.cashboxes.show.linked_to_order') }}</span>
                                @endif
                            </p>
                        </div>
                        <div class="modal-footer border-0 justify-content-center gap-2 pb-4">
                            <button type="button" class="btn btn-outline-secondary btn-rounded" data-bs-dismiss="modal">
                                {{ __('app.cashboxes.show.cancel') }}
                            </button>
                            <form action="{{ route('admin.cashboxes.entries.destroy', ['cashbox' => $cashbox->id, 'entry' => $entry->id]) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-rounded">
                                    <i class="bi bi-trash me-2"></i>{{ __('app.cashboxes.show.delete') }}
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    @endcan
@endsection


