@extends('layouts.admin', ['title' => __('app.cashboxes.new_title')])

@section('admin-content')
    <form action="{{ route('admin.cashboxes.store') }}" method="POST" class="row g-3">
        @csrf
        <div class="col-md-6">
            <label class="form-label">{{ __('app.cashboxes.form.name') }}</label>
            <input type="text" name="name" class="form-control rounded-4" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">{{ __('app.cashboxes.form.starting_balance') }}</label>
            <input type="number" step="0.5" min="0" name="starting_balance" class="form-control rounded-4" required>
        </div>
        <div class="col-12">
            <label class="form-label">{{ __('app.cashboxes.form.notes') }}</label>
            <textarea name="notes" rows="3" class="form-control rounded-4"></textarea>
        </div>
        <div class="col-12 d-flex gap-2">
            <button class="btn btn-primary btn-rounded" type="submit">{{ __('app.cashboxes.form.save') }}</button>
            <a href="{{ route('admin.cashboxes.index') }}" class="btn btn-outline-secondary btn-rounded">{{ __('app.cashboxes.form.cancel') }}</a>
        </div>
    </form>
@endsection


