<?php

return [
    'brand' => 'Lavandera',
    'tagline' => 'Professional Laundry Suite',
    'locale' => [
        'label' => 'Language',
        'en' => 'English',
        'ar' => 'Arabic',
        'fr' => 'French',
    ],
    'nav' => [
        'front' => 'Front Office',
        'admin' => 'Admin Dashboard',
    ],
    'front' => [
        'title' => 'Lavandera · Service Desk',
        'intro' => 'Create Service',
        'badge' => 'Live totals',
        'heading' => 'Front Office · Sky-fast workflow',
        'gender_label' => '1 · Select Gender',
        'male' => 'Male',
        'female' => 'Female',
        'service_label' => '2 · Choose Service Type',
        'washing' => 'Washing',
        'ironing' => 'Ironing',
        'items_label' => '3 · Tap items to add',
        'search_items' => 'Search items...',
        'no_search_results' => 'No results found',
        'item_hint' => 'Tap + to add quantity',
        'quantity' => 'Quantity',
        'add_to_cart' => 'Add',
        'added' => 'Added',
        'remove_item' => 'Remove item',
        'clear_order' => 'Clear Order',
        'clear_order_confirm' => 'Do you want to remove all items from the order?',
        'order_cleared' => 'Order cleared',
        'color_label' => 'Color',
        'color_placeholder' => 'Select color',
        'colors' => [
            'white' => 'White',
            'black' => 'Black',
            'red' => 'Red',
            'blue' => 'Blue',
            'green' => 'Green',
            'yellow' => 'Yellow',
            'orange' => 'Orange',
            'purple' => 'Purple',
            'pink' => 'Pink',
            'brown' => 'Brown',
            'gray' => 'Gray',
            'beige' => 'Beige',
            'navy' => 'Navy',
            'other' => 'Other',
        ],
        'summary' => 'Order Summary',
        'customer' => 'Customer name',
        'discount' => 'Discount',
        'subtotal' => 'Subtotal',
        'total' => 'Total',
        'mark_paid' => 'Mark as paid',
        'save' => 'Save order',
        'save_print' => 'Save & Print',
        'receipt_copies' => 'Receipt copies',
        'receipt_hint' => 'Receipts include a dynamic barcode for processing & pickup.',
        'toast_success' => 'Order saved successfully.',
        'toast_error' => 'Unable to save order.',
        'walk_in' => 'Walk-in Customer',
        'receipt' => [
            'title' => 'Receipt',
            'copy' => 'Copy',
            'of' => 'of',
            'order' => 'Order',
            'barcode' => 'Barcode',
            'date' => 'Date',
            'customer' => 'Customer',
            'walk_in' => 'Walk-in Customer',
            'gender' => 'Gender',
            'service' => 'Service',
            'status' => 'Status',
            'item' => 'Item',
            'qty' => 'Qty',
            'unit' => 'Unit',
            'total' => 'Total',
            'subtotal' => 'Subtotal',
            'discount' => 'Discount',
            'payment_status' => 'Payment status',
            'thank_you' => 'Thank you for choosing Lavandera.',
            'scan_hint' => 'Scan on delivery or pickup',
            'print' => 'Print receipt',
        ],
    ],
    'admin' => [
        'dashboard' => 'Dashboard',
        'orders' => 'Service Orders',
        'items' => 'Clothing Items',
        'transactions' => 'Accounting',
        'cashbox' => 'Cashbox',
        'settings' => 'Settings',
        'users' => 'Users',
        'roles' => 'Roles',
        'permissions' => 'Permissions',
        'quick_actions' => [
            'new_service' => 'New Service',
            'settings' => 'Settings',
        ],
    ],
    'dashboard_cards' => [
        'processing' => 'Processing Orders',
        'ready' => 'Ready for Pickup',
        'collected' => 'Collected Today',
        'revenue' => 'Revenue Today',
        'expenses' => 'Expenses Today',
        'cashbox' => 'Cashbox Balance',
        'recent_orders' => 'Recent Orders',
        'recent_transactions' => 'Recent Transactions',
        'orders_empty' => 'No orders yet.',
        'transactions_empty' => 'No transactions yet.',
    ],
    'orders' => [
        'search' => 'Search',
        'status' => 'Status',
        'all' => 'All',
        'filter' => 'Filter',
        'barcode' => 'Barcode',
        'new_service' => 'New service',
        'table' => [
            'order' => 'Order',
            'customer' => 'Customer',
            'service' => 'Service',
            'total' => 'Total',
            'status' => 'Status',
            'payment' => 'Payment',
            'actions' => 'Actions',
        ],
        'manage' => 'Manage',
        'none' => 'No orders found.',
        'items_count' => '{0} No items|{1} :count item|[2,*] :count items',
        'show' => [
            'title' => 'Order :number',
            'barcode_label' => 'Barcode',
            'print_receipt' => 'Print receipt',
            'items' => 'Items',
            'item' => 'Item',
            'qty' => 'Qty',
            'line_total' => 'Line total',
            'subtotal' => 'Subtotal',
            'discount' => 'Discount',
            'total' => 'Total',
            'update_status' => 'Update Status',
            'status' => 'Status',
            'mark_paid' => 'Mark as paid',
            'save_changes' => 'Save changes',
            'barcode' => 'Barcode',
            'barcode_hint' => 'Scan to confirm completion or pickup.',
            'delete' => 'Delete Order',
            'delete_confirm' => 'Are you sure you want to delete this order?',
            'cancel' => 'Cancel',
            'deleted' => 'Order :number deleted successfully.',
            'statuses' => [
                'pending' => 'Pending',
                'processing' => 'Processing',
                'ready' => 'Ready',
                'completed' => 'Completed',
                'collected' => 'Collected',
                'paid' => 'Paid',
                'unpaid' => 'Unpaid',
            ],
            'updated' => 'Order updated successfully.',
        ],
    ],
    'items' => [
        'title' => 'Clothing Items',
        'catalog' => 'Item catalog',
        'description' => 'Control pricing for washing & ironing.',
        'new_item' => 'New item',
        'table' => [
            'item' => 'Item',
            'wash' => 'Wash',
            'iron' => 'Iron',
            'status' => 'Status',
            'actions' => 'Actions',
        ],
        'active' => 'Active',
        'hidden' => 'Hidden',
        'edit' => 'Edit',
        'delete' => 'Delete',
        'delete_confirm' => 'Delete this item?',
        'form' => [
            'name' => 'Name',
            'slug' => 'Slug',
            'slug_placeholder' => 'auto-generated if empty',
            'image' => 'Image',
            'image_hint' => 'Upload an image file (JPG, PNG, GIF, WebP, max 2MB)',
            'washing_price' => 'Washing price',
            'ironing_price' => 'Ironing price',
            'active' => 'Active',
            'save' => 'Save',
            'cancel' => 'Cancel',
        ],
        'new_title' => 'New Item',
        'edit_title' => 'Edit Item',
        'created' => 'Item created successfully.',
        'updated' => 'Item updated successfully.',
        'deleted' => 'Item removed.',
    ],
    'cashboxes' => [
        'title' => 'Cashboxes',
        'heading' => 'Cash & Treasury',
        'description' => 'Control physical cash drawers.',
        'new_cashbox' => 'New cashbox',
        'balance' => 'Balance',
        'movements' => 'movements',
        'open' => 'Open',
        'new_title' => 'New Cashbox',
        'edit_title' => 'Edit Cashbox',
        'form' => [
            'name' => 'Name',
            'starting_balance' => 'Starting balance',
            'notes' => 'Notes',
            'save' => 'Save',
            'cancel' => 'Cancel',
        ],
        'show' => [
            'balance' => 'Balance',
            'edit' => 'Edit',
            'date' => 'Date',
            'direction' => 'Direction',
            'amount' => 'Amount',
            'balance' => 'Balance',
            'in' => 'In',
            'out' => 'Out',
            'none' => 'No entries yet.',
            'actions' => 'Actions',
            'locked' => 'Locked',
            'delete' => 'Delete',
            'delete_confirm' => 'Are you sure you want to delete this entry?',
            'cancel' => 'Cancel',
            'entry_deleted' => 'Entry deleted successfully.',
            'cannot_delete_locked' => 'Cannot delete entry linked to a service order.',
            'linked_to_order' => 'Linked to service order',
        ],
        'created' => 'Cashbox created successfully.',
        'updated' => 'Cashbox updated successfully.',
        'deleted' => 'Cashbox removed.',
        'cannot_delete_with_entries' => 'Cannot delete a cashbox with entries.',
    ],
    'settings' => [
        'title' => 'Settings',
        'company_name' => 'Company name',
        'phone' => 'Phone',
        'address' => 'Address',
        'barcode_prefix' => 'Barcode prefix',
        'order_prefix' => 'Order prefix',
        'receipt_copies' => 'Receipt copies',
        'currency' => 'Currency',
        'save_changes' => 'Save changes',
        'cancel' => 'Cancel',
        'updated' => 'Settings saved successfully.',
    ],
    'transactions' => [
        'title' => 'Accounting',
        'cashflow_monitor' => 'Cashflow monitor',
        'description' => 'Track incomes, expenses & treasury.',
        'new_transaction' => 'New transaction',
        'type' => 'Type',
        'all' => 'All',
        'income' => 'Income',
        'expense' => 'Expense',
        'from' => 'From',
        'to' => 'To',
        'apply' => 'Apply',
        'date' => 'Date',
        'category' => 'Category',
        'amount' => 'Amount',
        'cashbox' => 'Cashbox',
        'description' => 'Description',
        'optional_notes' => 'Optional notes',
        'save' => 'Save',
        'cancel' => 'Cancel',
        'view' => 'View',
        'edit' => 'Edit',
        'delete' => 'Delete',
        'back' => 'Back',
        'locked' => 'Locked',
        'none' => 'No transactions recorded.',
        'new_title' => 'New Transaction',
        'edit_title' => 'Edit Transaction',
        'show_title' => 'Transaction',
        'delete_confirm' => 'Delete this transaction?',
        'created' => 'Transaction recorded.',
        'updated' => 'Transaction updated.',
        'deleted' => 'Transaction removed.',
        'locked_error' => 'System generated transactions are locked.',
        'cannot_delete' => 'System generated transactions cannot be deleted.',
    ],
    'users' => [
        'title' => 'Users',
        'description' => 'Manage users and roles.',
        'new_user' => 'New User',
        'new_title' => 'New User',
        'edit_title' => 'Edit User',
        'edit_user' => 'Edit User',
        'create_description' => 'Add a new user to the system.',
        'edit_description' => 'Edit user information.',
        'back' => 'Back',
        'no_role' => 'No Role',
        'table' => [
            'name' => 'Name',
            'email' => 'Email',
            'role' => 'Role',
            'created' => 'Created',
        ],
        'form' => [
            'name' => 'Name',
            'email' => 'Email',
            'password' => 'Password',
            'password_confirmation' => 'Confirm Password',
            'password_optional' => 'Leave empty if you don\'t want to change the password',
            'role' => 'Role',
            'select_role' => 'Select Role',
            'save' => 'Save',
            'cancel' => 'Cancel',
        ],
        'edit' => 'Edit',
        'delete' => 'Delete',
        'delete_confirm' => 'Do you want to delete this user?',
        'created' => 'User created successfully.',
        'updated' => 'User updated successfully.',
        'deleted' => 'User deleted.',
        'cannot_delete_self' => 'You cannot delete your own account.',
    ],
    'roles' => [
        'title' => 'Roles',
        'description' => 'Manage roles and permissions.',
        'new_role' => 'New Role',
        'new_title' => 'New Role',
        'edit_title' => 'Edit Role',
        'edit_role' => 'Edit Role',
        'create_description' => 'Add a new role with permissions.',
        'edit_description' => 'Edit role and its permissions.',
        'back' => 'Back',
        'other' => 'Other',
        'table' => [
            'name' => 'Name',
            'display_name' => 'Display Name',
            'users_count' => 'Users',
            'permissions_count' => 'Permissions',
        ],
        'form' => [
            'name' => 'Name',
            'name_hint' => 'Unique role name (e.g., admin, manager)',
            'display_name' => 'Display Name',
            'description' => 'Description',
            'permissions' => 'Permissions',
            'save' => 'Save',
            'cancel' => 'Cancel',
        ],
        'edit' => 'Edit',
        'delete' => 'Delete',
        'delete_confirm' => 'Do you want to delete this role?',
        'created' => 'Role created successfully.',
        'updated' => 'Role updated successfully.',
        'deleted' => 'Role deleted.',
        'cannot_delete_system' => 'Cannot delete system roles (admin, manager, cashier).',
    ],
    'permissions' => [
        'title' => 'Permissions',
        'description' => 'Manage available permissions in the system.',
        'new_permission' => 'New Permission',
        'new_title' => 'New Permission',
        'edit_title' => 'Edit Permission',
        'edit_permission' => 'Edit Permission',
        'create_description' => 'Add a new permission to the system.',
        'edit_description' => 'Edit permission information.',
        'back' => 'Back',
        'other' => 'Other',
        'table' => [
            'name' => 'Name',
            'display_name' => 'Display Name',
            'description' => 'Description',
            'roles_count' => 'Roles',
        ],
        'form' => [
            'name' => 'Name',
            'name_hint' => 'Unique permission name (e.g., manage_users, view_orders)',
            'display_name' => 'Display Name',
            'description' => 'Description',
            'group' => 'Group',
            'group_placeholder' => 'e.g., users, orders, settings',
            'group_hint' => 'To group similar permissions',
            'save' => 'Save',
            'cancel' => 'Cancel',
        ],
        'edit' => 'Edit',
        'delete' => 'Delete',
        'delete_confirm' => 'Do you want to delete this permission?',
        'created' => 'Permission created successfully.',
        'updated' => 'Permission updated successfully.',
        'deleted' => 'Permission deleted.',
    ],
    'auth' => [
        'login' => 'Login',
        'logout' => 'Logout',
        'email' => 'Email',
        'password' => 'Password',
        'remember_me' => 'Remember me',
        'login_description' => 'Sign in to access the admin dashboard',
        'failed' => 'These credentials do not match our records.',
        'logged_out' => 'You have been logged out successfully.',
        'permission_denied' => 'You do not have permission to access this page.',
    ],
    'trial' => [
        'expired_title' => 'Trial Period Expired',
        'expired_message' => 'The 20-day trial period has ended. Please activate your license to continue using the system.',
        'trial_info' => 'Trial Information',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'total_days' => 'Total Duration',
        'days' => 'days',
        'days_remaining' => 'Days Remaining',
        'activate_license' => 'Activate License',
        'back_to_login' => 'Back to Login',
        'back_to_dashboard' => 'Back to Dashboard',
        'contact_support' => 'To obtain a license, please contact support',
        'warning_title' => 'Warning: Trial Period',
        'warning_message' => 'The trial period will expire in :days day(s). Please activate your license to continue using the system.',
        'remaining' => 'remaining',
        'dismiss' => 'Dismiss',
        'test_title' => 'Test Trial Period',
        'test_subtitle' => 'View trial period and license information',
        'status' => 'Status',
        'is_expired' => 'Is Expired',
        'is_expiring_soon' => 'Is Expiring Soon',
        'current_date' => 'Current Date',
        'yes' => 'Yes',
        'no' => 'No',
        'no_license' => 'No License Activated',
        'activate_to_continue' => 'Please activate your license to continue using the system',
        'detailed_info' => 'Detailed Information',
        'view_expired' => 'View Expired Page',
        'test_buttons' => 'Test Buttons',
        'test_buttons_desc' => 'Use these buttons to test different trial period scenarios',
        'set_18_days' => 'Set 18 Days (Warning - 2 Days Remaining)',
        'set_21_days' => 'Reset Trial (20 Additional Days)',
        'set_0_days' => 'Set 0 Days (Fully Expired)',
        'test_date_set' => 'Trial period date set to :days days remaining',
        'test_date_set_warning' => 'Date set: 18 days passed, 2 days remaining (warning will show)',
        'trial_reset' => 'Trial period reset successfully (20 new days)',
        'invalid_days' => 'Invalid number of days',
    ],
    'license' => [
        'activate_title' => 'Activate License',
        'activate_subtitle' => 'Enter your license key and serial number to activate the system',
        'license_key' => 'License Key',
        'license_key_hint' => 'Format: XXXX-XXXX-XXXX-XXXX',
        'serial_number' => 'Serial Number',
        'serial_number_hint' => 'Format: SN-XXXXXXXXXXXX',
        'customer_name' => 'Customer Name',
        'email' => 'Email',
        'activate' => 'Activate',
        'activated' => 'Successfully Activated',
        'license_info' => 'System is currently activated',
        'expires_at' => 'Expires At',
        'back_to_login' => 'Back to Login',
    ],
    'footer' => [
        'description' => 'Professional laundry management system providing comprehensive solutions for order management and accounting.',
        'quick_links' => 'Quick Links',
        'contact' => 'Contact Us',
        'info' => 'Information',
        'email' => 'Support@imranesoft.com',
        'phone' => '+212 674 42 77 48',
        'address' => 'Morocco',
        'version' => 'Version',
        'year' => 'Year',
        'license' => 'Commercial License',
        'all_rights_reserved' => 'All rights reserved',
        'developed_by' => 'Developed by ImraneSoft',
    ],
];

