<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get roles
        $adminRole = Role::where('name', 'admin')->first();
        $managerRole = Role::where('name', 'manager')->first();
        $cashierRole = Role::where('name', 'cashier')->first();

        if (!$adminRole || !$managerRole || !$cashierRole) {
            $this->command->error('Roles not found! Please run RolePermissionSeeder first.');
            return;
        }

        // Create Admin user
        User::firstOrCreate(
            ['email' => 'admin@lavandera.test'],
            [
                'name' => 'Administrator',
                'password' => Hash::make('password'),
                'role_id' => $adminRole->id,
            ]
        );

        // Create Manager user
        User::firstOrCreate(
            ['email' => 'manager@lavandera.test'],
            [
                'name' => 'Manager',
                'password' => Hash::make('password'),
                'role_id' => $managerRole->id,
            ]
        );

        // Create Cashier user
        User::firstOrCreate(
            ['email' => 'cashier@lavandera.test'],
            [
                'name' => 'Cashier',
                'password' => Hash::make('password'),
                'role_id' => $cashierRole->id,
            ]
        );

        $this->command->info('Users created successfully!');
        $this->command->info('Admin: admin@lavandera.test / password');
        $this->command->info('Manager: manager@lavandera.test / password');
        $this->command->info('Cashier: cashier@lavandera.test / password');
    }
}
