<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    protected $connection = 'activation';

    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::connection('activation')->create('activations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('activation_key_id')->constrained('activation_keys')->onDelete('cascade');
            $table->string('machine_id')->nullable();
            $table->timestamp('activated_at')->nullable();
            $table->timestamp('expires_at')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::connection('activation')->dropIfExists('activations');
    }
};
