<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update existing data: pending -> processing, completed -> collected
        DB::table('service_orders')
            ->where('status', 'pending')
            ->update(['status' => 'processing']);
        
        DB::table('service_orders')
            ->where('status', 'completed')
            ->update(['status' => 'collected']);

        // Change enum to varchar temporarily
        DB::statement("ALTER TABLE service_orders MODIFY status VARCHAR(20) NOT NULL DEFAULT 'processing'");

        // Change back to enum with new values
        DB::statement("ALTER TABLE service_orders MODIFY status ENUM('processing', 'ready', 'collected') NOT NULL DEFAULT 'processing'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert data changes
        DB::table('service_orders')
            ->where('status', 'processing')
            ->update(['status' => 'pending']);
        
        DB::table('service_orders')
            ->where('status', 'collected')
            ->whereNotNull('collected_at')
            ->update(['status' => 'completed']);

        // Change enum back to original
        DB::statement("ALTER TABLE service_orders MODIFY status VARCHAR(20) NOT NULL DEFAULT 'pending'");
        DB::statement("ALTER TABLE service_orders MODIFY status ENUM('pending', 'processing', 'ready', 'completed', 'collected') NOT NULL DEFAULT 'pending'");
    }
};
