<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'key',
        'value',
    ];

    public static function getValue(string $key, $default = null)
    {
        return static::query()->where('key', $key)->value('value') ?? $default;
    }

    public static function setValue(string $key, $value): void
    {
        static::updateOrCreate(['key' => $key], ['value' => $value]);
    }

    // Alias methods for compatibility
    public static function get(string $key, $default = null)
    {
        return static::getValue($key, $default);
    }

    public static function set(string $key, $value): void
    {
        static::setValue($key, $value);
    }

    public static function forget(string $key): void
    {
        static::where('key', $key)->delete();
    }
}
