<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClothingItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'image_path',
        'default_wash_price',
        'default_iron_price',
        'is_active',
    ];

    protected $casts = [
        'default_wash_price' => 'decimal:2',
        'default_iron_price' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    public function getImageUrlAttribute(): string
    {
        if ($this->image_path) {
            // Check if it's a URL (starts with http)
            if (str_starts_with($this->image_path, 'http')) {
                return $this->image_path;
            }
            // Otherwise, return path from public/images
            return asset('images/' . $this->image_path);
        }
        
        return asset('images/placeholder.png');
    }
}


