<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Cashbox extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'starting_balance',
        'current_balance',
        'notes',
    ];

    protected $casts = [
        'starting_balance' => 'decimal:2',
        'current_balance' => 'decimal:2',
    ];

    public function entries(): HasMany
    {
        return $this->hasMany(CashboxEntry::class);
    }

    public function transactions(): HasMany
    {
        return $this->hasMany(FinancialTransaction::class);
    }

    public function recordEntry(float $amount, string $direction, ?FinancialTransaction $transaction = null): CashboxEntry
    {
        $amount = round($amount, 2);

        if ($direction === 'in') {
            $this->current_balance = $this->current_balance + $amount;
        } else {
            $this->current_balance = $this->current_balance - $amount;
        }

        $this->save();

        return $this->entries()->create([
            'financial_transaction_id' => $transaction?->id,
            'direction' => $direction,
            'amount' => $amount,
            'running_balance' => $this->current_balance,
        ]);
    }
}
