<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ActivationKey extends Model
{
    protected $connection = 'activation';

    protected $fillable = [
        'key',
        'days',
        'is_used',
        'used_at',
    ];

    protected $casts = [
        'is_used' => 'boolean',
        'used_at' => 'datetime',
    ];

    public function activation(): HasOne
    {
        return $this->hasOne(Activation::class);
    }
}
