<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Activation extends Model
{
    protected $connection = 'activation';

    protected $fillable = [
        'activation_key_id',
        'machine_id',
        'activated_at',
        'expires_at',
        'is_active',
    ];

    protected $casts = [
        'activated_at' => 'datetime',
        'expires_at' => 'datetime',
        'is_active' => 'boolean',
    ];

    public function activationKey(): BelongsTo
    {
        return $this->belongsTo(ActivationKey::class);
    }

    public function isExpired(): bool
    {
        return $this->expires_at && $this->expires_at->isPast();
    }

    public function daysRemaining(): int
    {
        if (!$this->expires_at || $this->isExpired()) {
            return 0;
        }

        return max(0, now()->diffInDays($this->expires_at, false));
    }
}
