<?php

namespace App\Http\Controllers;

use App\Services\LicenseService;
use Illuminate\Http\Request;

class LicenseController extends Controller
{
    protected $licenseService;

    public function __construct(LicenseService $licenseService)
    {
        $this->licenseService = $licenseService;
    }

    /**
     * عرض صفحة إدخال مفتاح الترخيص
     */
    public function showActivationForm()
    {
        $licenseInfo = $this->licenseService->getLicenseInfo();
        
        return view('license.activate', compact('licenseInfo'));
    }

    /**
     * تفعيل الترخيص
     */
    public function activate(Request $request)
    {
        $request->validate([
            'license_key' => 'required|string|min:10',
            'serial_number' => 'required|string|min:10',
            'email' => 'nullable|email',
            'name' => 'nullable|string',
        ]);

        $result = $this->licenseService->activate(
            $request->license_key,
            $request->serial_number,
            [
                'email' => $request->email,
                'name' => $request->name,
            ]
        );

        if ($result['success']) {
            return redirect()->route('license.activate')
                ->with('success', __('app.license.activated'));
        }

        return back()->withErrors(['license' => $result['message']])
            ->withInput();
    }
}



