<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function edit()
    {
        $settings = [
            'company_name' => Setting::getValue('company_name', 'Lavandera'),
            'company_address' => Setting::getValue('company_address', '123 Laundry Street'),
            'company_phone' => Setting::getValue('company_phone', '+000 000 0000'),
            'barcode_prefix' => Setting::getValue('barcode_prefix', 'MSB'),
            'receipt_copies' => Setting::getValue('receipt_copies', '1'),
            'order_prefix' => Setting::getValue('order_prefix', 'MSB'),
            'currency' => Setting::getValue('currency', 'USD'),
        ];

        return view('admin.settings.edit', compact('settings'));
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'company_name' => ['required', 'string', 'max:120'],
            'company_address' => ['nullable', 'string', 'max:255'],
            'company_phone' => ['nullable', 'string', 'max:60'],
            'barcode_prefix' => ['required', 'string', 'max:10'],
            'receipt_copies' => ['required', 'integer', 'min:1', 'max:4'],
            'order_prefix' => ['required', 'string', 'max:10'],
            'currency' => ['required', 'string', 'max:10'],
        ]);

        foreach ($data as $key => $value) {
            Setting::setValue($key, (string) $value);
        }

        return back()->with('status', __('app.settings.updated'));
    }
}
