<p align="center">
  <img src="https://images.ctfassets.net/5de70he6op10/6mKFFnzvoluSk5G8f7IqZu/379f1bc105b9566e7e0e92ce40938e35/2024q1_masbana_laundry.png" alt="Lavandera Logo" width="320">
</p>

# Lavandera Laundry Suite

Lavandera is a modern, lightweight management platform for professional laundry services. Built with **Laravel 12**, **Bootstrap 5**, **jQuery + AJAX**, and **MySQL**, it delivers a lightning-fast front-office intake flow, barcode-driven operations, and a full back-office for pricing, inventory, and accounting.

## Features

- **Service Desk (Front Office)**  
  Gender + service selection, visual garment catalog, live totals, discounting, instant receipt printing with barcodes.

- **Barcode Workflow**  
  Unique barcode per order, lookup & confirmation endpoints, printable receipts with CODE128 barcodes.

- **Admin Dashboard**  
  KPIs for orders/revenue/expenses, recent activity feed, sky-blue UI.

- **Catalog & Pricing**  
  Manage clothing items, washing/ironing prices, activation toggle, cloud-hosted imagery.

- **Accounting & Cashbox**  
  Income/expense tracking, manual transactions, cashbox balances, auto entries when payments are captured.

- **Settings**  
  Tune company identity, barcode/order prefixes, currency, receipt copies.

- **Localization**  
  Built-in English, Arabic (RTL), and French interfaces with instant language switcher.

## Tech Stack

- PHP 8.3+, Laravel 12
- MySQL 8 (database name **`masbana`** - can be changed in .env)
- Bootstrap 5.3, jQuery 3.7, Axios, JsBarcode

## Getting Started

```bash
cp .env.example .env   # update DB_DATABASE=masbana (or your preferred name) etc.
composer install
php artisan key:generate
php artisan migrate --seed
npm install && npm run build   # optional (views use CDN assets by default)
php artisan serve
```

Open **`http://localhost:8000`** for the front-office UI and **`/admin`** for the dashboard.

> Default seeded credentials: `admin@lavandera.test` / `password`

## Testing

```bash
php artisan test
```

## License

MIT © Lavandera Laundry Service
